/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.internal.util.GridUnsafe;

public class PlatformMemoryUtils {
    public static final int POOL_HDR_LEN = 64;
    public static final int POOL_HDR_OFF_MEM_1 = 0;
    public static final int POOL_HDR_OFF_MEM_2 = 20;
    public static final int POOL_HDR_OFF_MEM_3 = 40;
    public static final int MEM_HDR_LEN = 20;
    public static final int MEM_HDR_OFF_CAP = 8;
    public static final int MEM_HDR_OFF_LEN = 12;
    public static final int MEM_HDR_OFF_FLAGS = 16;
    public static final int FLAG_EXT = 1;
    public static final int FLAG_POOLED = 2;
    public static final int FLAG_ACQUIRED = 4;

    public static long data(long memPtr) {
        return GridUnsafe.getLong(memPtr);
    }

    public static int capacity(long memPtr) {
        return GridUnsafe.getInt(memPtr + 8L);
    }

    public static void capacity(long memPtr, int cap) {
        assert (!PlatformMemoryUtils.isExternal(memPtr)) : "Attempt to update external memory chunk capacity: " + memPtr;
        GridUnsafe.putInt(memPtr + 8L, cap);
    }

    public static int length(long memPtr) {
        return GridUnsafe.getInt(memPtr + 12L);
    }

    public static void length(long memPtr, int len) {
        GridUnsafe.putInt(memPtr + 12L, len);
    }

    public static int flags(long memPtr) {
        return GridUnsafe.getInt(memPtr + 16L);
    }

    public static void flags(long memPtr, int flags) {
        assert (!PlatformMemoryUtils.isExternal(memPtr)) : "Attempt to update external memory chunk flags: " + memPtr;
        GridUnsafe.putInt(memPtr + 16L, flags);
    }

    public static boolean isExternal(long memPtr) {
        return PlatformMemoryUtils.isExternal(PlatformMemoryUtils.flags(memPtr));
    }

    public static boolean isExternal(int flags) {
        return (flags & 1) == 1;
    }

    public static boolean isPooled(long memPtr) {
        return PlatformMemoryUtils.isPooled(PlatformMemoryUtils.flags(memPtr));
    }

    public static boolean isPooled(int flags) {
        return (flags & 2) != 0;
    }

    public static boolean isAcquired(long memPtr) {
        return PlatformMemoryUtils.isAcquired(PlatformMemoryUtils.flags(memPtr));
    }

    public static boolean isAcquired(int flags) {
        assert (PlatformMemoryUtils.isPooled(flags));
        return (flags & 4) != 0;
    }

    public static long allocateUnpooled(int cap) {
        assert (cap > 0);
        long memPtr = GridUnsafe.allocateMemory(20L);
        long dataPtr = GridUnsafe.allocateMemory(cap);
        GridUnsafe.putLong(memPtr, dataPtr);
        GridUnsafe.putInt(memPtr + 8L, cap);
        GridUnsafe.putInt(memPtr + 12L, 0);
        GridUnsafe.putInt(memPtr + 16L, 0);
        return memPtr;
    }

    public static void reallocateUnpooled(long memPtr, int cap) {
        long newDataPtr;
        assert (cap > 0);
        assert (!PlatformMemoryUtils.isExternal(memPtr)) : "Attempt to reallocate external memory chunk directly: " + memPtr;
        assert (!PlatformMemoryUtils.isPooled(memPtr)) : "Attempt to reallocate pooled memory chunk directly: " + memPtr;
        long dataPtr = PlatformMemoryUtils.data(memPtr);
        if (dataPtr != (newDataPtr = GridUnsafe.reallocateMemory(dataPtr, cap))) {
            GridUnsafe.putLong(memPtr, newDataPtr);
        }
        GridUnsafe.putInt(memPtr + 8L, cap);
    }

    public static void releaseUnpooled(long memPtr) {
        assert (!PlatformMemoryUtils.isExternal(memPtr)) : "Attempt to release external memory chunk directly: " + memPtr;
        assert (!PlatformMemoryUtils.isPooled(memPtr)) : "Attempt to release pooled memory chunk directly: " + memPtr;
        GridUnsafe.freeMemory(PlatformMemoryUtils.data(memPtr));
        GridUnsafe.freeMemory(memPtr);
    }

    public static long allocatePool() {
        long poolPtr = GridUnsafe.allocateMemory(64L);
        GridUnsafe.zeroMemory(poolPtr, 64L);
        PlatformMemoryUtils.flags(poolPtr + 0L, 2);
        PlatformMemoryUtils.flags(poolPtr + 20L, 2);
        PlatformMemoryUtils.flags(poolPtr + 40L, 2);
        return poolPtr;
    }

    public static void releasePool(long poolPtr) {
        long mem = GridUnsafe.getLong(poolPtr + 0L);
        if (mem != 0L) {
            GridUnsafe.freeMemory(mem);
        }
        if ((mem = GridUnsafe.getLong(poolPtr + 20L)) != 0L) {
            GridUnsafe.freeMemory(mem);
        }
        if ((mem = GridUnsafe.getLong(poolPtr + 40L)) != 0L) {
            GridUnsafe.freeMemory(mem);
        }
        GridUnsafe.freeMemory(poolPtr);
    }

    public static long allocatePooled(long poolPtr, int cap) {
        long memPtr1 = poolPtr + 0L;
        if (PlatformMemoryUtils.isAcquired(memPtr1)) {
            long memPtr2 = poolPtr + 20L;
            if (PlatformMemoryUtils.isAcquired(memPtr2)) {
                long memPtr3 = poolPtr + 40L;
                if (PlatformMemoryUtils.isAcquired(memPtr3)) {
                    return 0L;
                }
                PlatformMemoryUtils.allocatePooled0(memPtr3, cap);
                return memPtr3;
            }
            PlatformMemoryUtils.allocatePooled0(memPtr2, cap);
            return memPtr2;
        }
        PlatformMemoryUtils.allocatePooled0(memPtr1, cap);
        return memPtr1;
    }

    private static void allocatePooled0(long memPtr, int cap) {
        assert (!PlatformMemoryUtils.isExternal(memPtr));
        assert (PlatformMemoryUtils.isPooled(memPtr));
        assert (!PlatformMemoryUtils.isAcquired(memPtr));
        long data = GridUnsafe.getLong(memPtr);
        if (data == 0L) {
            data = GridUnsafe.allocateMemory(cap);
            GridUnsafe.putLong(memPtr, data);
            GridUnsafe.putInt(memPtr + 8L, cap);
        } else {
            int curCap = PlatformMemoryUtils.capacity(memPtr);
            if (cap > curCap) {
                data = GridUnsafe.reallocateMemory(data, cap);
                GridUnsafe.putLong(memPtr, data);
                GridUnsafe.putInt(memPtr + 8L, cap);
            }
        }
        PlatformMemoryUtils.flags(memPtr, 6);
    }

    public static void reallocatePooled(long memPtr, int cap) {
        assert (!PlatformMemoryUtils.isExternal(memPtr));
        assert (PlatformMemoryUtils.isPooled(memPtr));
        assert (PlatformMemoryUtils.isAcquired(memPtr));
        long data = GridUnsafe.getLong(memPtr);
        assert (data != 0L);
        int curCap = PlatformMemoryUtils.capacity(memPtr);
        if (cap > curCap) {
            data = GridUnsafe.reallocateMemory(data, cap);
            GridUnsafe.putLong(memPtr, data);
            GridUnsafe.putInt(memPtr + 8L, cap);
        }
    }

    public static void releasePooled(long memPtr) {
        assert (!PlatformMemoryUtils.isExternal(memPtr));
        assert (PlatformMemoryUtils.isPooled(memPtr));
        assert (PlatformMemoryUtils.isAcquired(memPtr));
        PlatformMemoryUtils.flags(memPtr, PlatformMemoryUtils.flags(memPtr) ^ 4);
    }

    public static void reallocate(long memPtr, int cap) {
        int flags = PlatformMemoryUtils.flags(memPtr);
        if (PlatformMemoryUtils.isPooled(flags)) {
            PlatformMemoryUtils.reallocatePooled(memPtr, cap);
        } else {
            assert (!PlatformMemoryUtils.isExternal(flags));
            PlatformMemoryUtils.reallocateUnpooled(memPtr, cap);
        }
    }

    private PlatformMemoryUtils() {
    }
}

