/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.pagemem;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointLockStateChecker;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.CheckpointBufferOverflowWatchdog;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.ExponentialBackoffThrottlingStrategy;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PagesWriteThrottlePolicy;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;

public class PagesWriteThrottle
implements PagesWriteThrottlePolicy {
    private final PageMemoryImpl pageMemory;
    private final IgniteOutClosure<CheckpointProgress> cpProgress;
    private final boolean throttleOnlyPagesInCheckpoint;
    private final CheckpointLockStateChecker stateChecker;
    private final ExponentialBackoffThrottlingStrategy inCheckpointProtection = new ExponentialBackoffThrottlingStrategy();
    private final ExponentialBackoffThrottlingStrategy notInCheckpointProtection = new ExponentialBackoffThrottlingStrategy();
    private final CheckpointBufferOverflowWatchdog cpBufferWatchdog;
    private final IgniteLogger log;
    private final ConcurrentHashMap<Long, Thread> cpBufThrottledThreads = new ConcurrentHashMap();

    public PagesWriteThrottle(PageMemoryImpl pageMemory, IgniteOutClosure<CheckpointProgress> cpProgress, CheckpointLockStateChecker stateChecker, boolean throttleOnlyPagesInCheckpoint, IgniteLogger log) {
        this.pageMemory = pageMemory;
        this.cpProgress = cpProgress;
        this.stateChecker = stateChecker;
        this.throttleOnlyPagesInCheckpoint = throttleOnlyPagesInCheckpoint;
        this.cpBufferWatchdog = new CheckpointBufferOverflowWatchdog(pageMemory);
        this.log = log;
        assert (throttleOnlyPagesInCheckpoint || cpProgress != null) : "cpProgress must be not null if ratio based throttling mode is used";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMarkDirty(boolean isPageInCheckpoint) {
        ExponentialBackoffThrottlingStrategy exponentialThrottle;
        assert (this.stateChecker.checkpointLockIsHeldByThread());
        boolean shouldThrottle = false;
        if (isPageInCheckpoint) {
            shouldThrottle = this.isCpBufferOverflowThresholdExceeded();
        }
        if (!shouldThrottle && !this.throttleOnlyPagesInCheckpoint) {
            int cpTotalPages;
            AtomicInteger writtenPagesCntr;
            CheckpointProgress progress = this.cpProgress.apply();
            AtomicInteger atomicInteger = writtenPagesCntr = progress == null ? null : this.cpProgress.apply().writtenPagesCounter();
            if (progress == null || writtenPagesCntr == null) {
                return;
            }
            int cpWrittenPages = writtenPagesCntr.get();
            if (cpWrittenPages == (cpTotalPages = progress.currentCheckpointPagesCount())) {
                shouldThrottle = this.pageMemory.shouldThrottle(0.75);
            } else {
                double dirtyRatioThreshold = (double)cpWrittenPages / (double)cpTotalPages;
                dirtyRatioThreshold = (dirtyRatioThreshold * 0.95 + 0.05) * 7.0 / 12.0;
                shouldThrottle = this.pageMemory.shouldThrottle(dirtyRatioThreshold);
            }
        }
        ExponentialBackoffThrottlingStrategy exponentialBackoffThrottlingStrategy = exponentialThrottle = isPageInCheckpoint ? this.inCheckpointProtection : this.notInCheckpointProtection;
        if (shouldThrottle) {
            long throttleParkTimeNs = exponentialThrottle.protectionParkTime();
            Thread curThread = Thread.currentThread();
            if (throttleParkTimeNs > LOGGING_THRESHOLD) {
                U.warn(this.log, "Parking thread=" + curThread.getName() + " for timeout(ms)=" + throttleParkTimeNs / 1000000L);
            }
            long startTime = U.currentTimeMillis();
            if (isPageInCheckpoint) {
                this.cpBufThrottledThreads.put(curThread.getId(), curThread);
                try {
                    LockSupport.parkNanos(throttleParkTimeNs);
                }
                finally {
                    this.cpBufThrottledThreads.remove(curThread.getId());
                    if (throttleParkTimeNs > LOGGING_THRESHOLD) {
                        U.warn(this.log, "Unparking thread=" + curThread.getName() + " with park timeout(ms)=" + throttleParkTimeNs / 1000000L);
                    }
                }
            } else {
                LockSupport.parkNanos(throttleParkTimeNs);
            }
            this.pageMemory.metrics().addThrottlingTime(U.currentTimeMillis() - startTime);
        } else {
            boolean backoffWasAlreadyStarted = exponentialThrottle.resetBackoff();
            if (isPageInCheckpoint && backoffWasAlreadyStarted) {
                this.unparkParkedThreads();
            }
        }
    }

    @Override
    public void wakeupThrottledThreads() {
        if (!this.isCpBufferOverflowThresholdExceeded()) {
            this.inCheckpointProtection.resetBackoff();
            this.unparkParkedThreads();
        }
    }

    private void unparkParkedThreads() {
        this.cpBufThrottledThreads.values().forEach(LockSupport::unpark);
    }

    @Override
    public void onBeginCheckpoint() {
    }

    @Override
    public void onFinishCheckpoint() {
        this.inCheckpointProtection.resetBackoff();
        this.notInCheckpointProtection.resetBackoff();
    }

    @Override
    public boolean isCpBufferOverflowThresholdExceeded() {
        return this.cpBufferWatchdog.isInDangerZone();
    }
}

