/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridKernalState;
import org.apache.ignite.internal.NodeStoppingException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryImplEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheMapEntry;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteRebalanceIterator;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounterDebugWrapper;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounterErrorWrapper;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounterTrackingImpl;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounterVolatileImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteHistoricalIterator;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteRebalanceIteratorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.DataRowCacheAware;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.RowStore;
import org.apache.ignite.internal.processors.cache.persistence.freelist.SimpleDataRow;
import org.apache.ignite.internal.processors.cache.persistence.partstorage.PartitionMetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.tree.CacheDataRowStore;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.DataRow;
import org.apache.ignite.internal.processors.cache.tree.PendingEntriesTree;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.processors.cache.tree.SearchRow;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;
import org.apache.ignite.internal.util.GridAtomicLong;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridLongList;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.GridStripedLock;
import org.apache.ignite.internal.util.collection.ImmutableIntSet;
import org.apache.ignite.internal.util.collection.IntMap;
import org.apache.ignite.internal.util.collection.IntRWHashMap;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.IgniteInClosure2X;
import org.apache.ignite.internal.util.lang.IgnitePredicateX;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheOffheapManagerImpl
implements IgniteCacheOffheapManager {
    public static final int PRELOAD_SIZE_UNDER_CHECKPOINT_LOCK = 100;
    private static final int BATCH_SIZE = 1000;
    protected GridCacheSharedContext ctx;
    protected CacheGroupContext grp;
    protected IgniteLogger log;
    private PendingEntriesTree pendingEntries;
    private final GridAtomicLong globalRmvId = new GridAtomicLong(U.currentTimeMillis() * 1000000L);
    protected final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    protected GridStripedLock partStoreLock = new GridStripedLock(Runtime.getRuntime().availableProcessors());
    private final AtomicBoolean stopping = new AtomicBoolean();

    @Override
    public GridAtomicLong globalRemoveId() {
        return this.globalRmvId;
    }

    @Override
    public void start(GridCacheSharedContext ctx, CacheGroupContext grp) throws IgniteCheckedException {
        this.ctx = ctx;
        this.grp = grp;
        this.log = ctx.logger(this.getClass());
        if (grp.affinityNode()) {
            ctx.database().checkpointReadLock();
            try {
                this.initDataStructures();
            }
            finally {
                ctx.database().checkpointReadUnlock();
            }
        }
    }

    @Override
    public void onCacheStarted(GridCacheContext cctx) throws IgniteCheckedException {
        this.initPendingTree(cctx);
    }

    protected void initPendingTree(GridCacheContext<?, ?> cctx) throws IgniteCheckedException {
        assert (!cctx.group().persistenceEnabled());
        if (cctx.affinityNode() && cctx.ttl().eagerTtlEnabled() && this.pendingEntries == null) {
            String pendingEntriesTreeName = cctx.name() + "##PendingEntries";
            long rootPage = this.allocateForTree();
            this.pendingEntries = new PendingEntriesTree(this.grp, pendingEntriesTreeName, this.grp.dataRegion().pageMemory(), rootPage, this.grp.reuseList(), true, this.ctx.diagnostic().pageLockTracker(), 2);
        }
    }

    protected void initDataStructures() throws IgniteCheckedException {
    }

    @Override
    public void stopCache(int cacheId, boolean destroy) {
        if (destroy && this.grp.affinityNode()) {
            this.removeCacheData(cacheId);
        }
    }

    @Override
    public void stop() {
        GridKernalContext kctx = this.ctx.kernalContext();
        if (kctx.gateway().getState() == GridKernalState.STOPPING || kctx.state().clusterState().state() == ClusterState.INACTIVE) {
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                store.tree().close();
            }
            if (this.pendingEntries != null) {
                this.pendingEntries.close();
            }
            return;
        }
        try {
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                this.destroyCacheDataStore(store);
            }
            if (this.pendingEntries != null) {
                this.pendingEntries.destroy();
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Override
    public long restoreStateOfPartition(int p, @Nullable Integer recoveryState) throws IgniteCheckedException {
        return 0L;
    }

    @Override
    public void restorePartitionStates() throws IgniteCheckedException {
    }

    @Override
    public void confirmPartitionStatesRestored() {
    }

    @Override
    public void onKernalStop() {
        if (this.stopping.compareAndSet(false, true)) {
            this.busyLock.block();
        }
    }

    @Override
    public void prepareToStop() {
        if (this.stopping.compareAndSet(false, true)) {
            this.busyLock.block();
        }
    }

    private void removeCacheData(int cacheId) {
        assert (this.grp.affinityNode());
        try {
            if (this.grp.sharedGroup()) {
                assert (cacheId != 0);
                for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
                    store.clear(cacheId);
                }
                if (this.pendingEntries != null) {
                    PendingRow row = new PendingRow(cacheId);
                    while (this.pendingEntries.removex(row, row, -1)) {
                    }
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e.getMessage(), e);
        }
    }

    @Nullable
    private IgniteCacheOffheapManager.CacheDataStore dataStore(GridCacheContext<?, ?> cctx, KeyCacheObject key) {
        return this.dataStore(cctx.affinity().partition(key), false);
    }

    @Override
    public IgniteCacheOffheapManager.CacheDataStore dataStore(@Nullable GridDhtLocalPartition part) {
        assert (part != null);
        return part.dataStore();
    }

    @Nullable
    private IgniteCacheOffheapManager.CacheDataStore dataStore(int partId, boolean includeRenting) {
        GridDhtLocalPartition part = this.grp.topology().localPartition(partId, AffinityTopologyVersion.NONE, false, includeRenting);
        return part == null ? null : part.dataStore();
    }

    @Override
    public long cacheEntriesCount(int cacheId) {
        long size = 0L;
        for (IgniteCacheOffheapManager.CacheDataStore store : this.cacheDataStores()) {
            size += store.cacheSize(cacheId);
        }
        return size;
    }

    @Override
    public void preloadPartition(int partId) throws IgniteCheckedException {
        throw new IgniteCheckedException("Operation only applicable to caches with enabled persistence");
    }

    @Override
    public long cacheEntriesCount(int cacheId, boolean primary, boolean backup, AffinityTopologyVersion topVer) {
        long cnt = 0L;
        Iterator<IgniteCacheOffheapManager.CacheDataStore> it = this.cacheData(primary, backup, topVer);
        while (it.hasNext()) {
            cnt += it.next().cacheSize(cacheId);
        }
        return cnt;
    }

    @Override
    public long cacheEntriesCount(int cacheId, int part) {
        IgniteCacheOffheapManager.CacheDataStore store = this.dataStore(part, true);
        return store == null ? 0L : store.cacheSize(cacheId);
    }

    @Override
    public Iterable<IgniteCacheOffheapManager.CacheDataStore> cacheDataStores() {
        return this.cacheDataStores(F.alwaysTrue());
    }

    private Iterable<IgniteCacheOffheapManager.CacheDataStore> cacheDataStores(IgnitePredicate<GridDhtLocalPartition> filter) {
        return F.iterator(this.grp.topology().currentLocalPartitions(), GridDhtLocalPartition::dataStore, true, filter, p -> !p.dataStore().destroyed());
    }

    private Iterator<IgniteCacheOffheapManager.CacheDataStore> cacheData(boolean primary, boolean backup, AffinityTopologyVersion topVer) {
        IgnitePredicate<GridDhtLocalPartition> filter;
        assert (primary || backup);
        if (primary && backup) {
            filter = F.alwaysTrue();
        } else {
            ImmutableIntSet parts = ImmutableIntSet.wrap(primary ? this.grp.affinity().primaryPartitions(this.ctx.localNodeId(), topVer) : this.grp.affinity().backupPartitions(this.ctx.localNodeId(), topVer));
            filter = part -> parts.contains(part.id());
        }
        return this.cacheDataStores(filter).iterator();
    }

    @Override
    public void invoke(GridCacheContext cctx, KeyCacheObject key, GridDhtLocalPartition part, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
        this.dataStore(part).invoke(cctx, key, c);
    }

    @Override
    public void update(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, GridDhtLocalPartition part, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
        assert (expireTime >= 0L);
        this.dataStore(part).update(cctx, key, val, ver, expireTime, oldRow);
    }

    @Override
    public void remove(GridCacheContext cctx, KeyCacheObject key, int partId, GridDhtLocalPartition part) throws IgniteCheckedException {
        this.dataStore(part).remove(cctx, key, partId);
    }

    @Override
    @Nullable
    public CacheDataRow read(GridCacheMapEntry entry) throws IgniteCheckedException {
        KeyCacheObject key = entry.key();
        assert (entry.localPartition() != null) : entry;
        return this.dataStore(entry.localPartition()).find(entry.context(), key);
    }

    @Override
    @Nullable
    public CacheDataRow read(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
        CacheDataRow row;
        IgniteCacheOffheapManager.CacheDataStore dataStore = this.dataStore(cctx, key);
        CacheDataRow cacheDataRow = row = dataStore != null ? dataStore.find(cctx, key) : null;
        assert (row == null || row.value() != null) : row;
        return row;
    }

    @Override
    public boolean containsKey(GridCacheMapEntry entry) {
        try {
            return this.read(entry) != null;
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to read value", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache(GridCacheContext cctx, boolean readers) {
        GridCacheVersion obsoleteVer = null;
        try (GridCloseableIterator<CacheDataRow> it = this.evictionSafeIterator(cctx.cacheId(), this.cacheDataStores().iterator());){
            while (it.hasNext()) {
                cctx.shared().database().checkpointReadLock();
                try {
                    KeyCacheObject key = ((CacheDataRow)it.next()).key();
                    try {
                        if (obsoleteVer == null) {
                            obsoleteVer = cctx.cache().nextVersion();
                        }
                        GridCacheEntryEx entry = cctx.cache().entryEx(key);
                        entry.clear(obsoleteVer, readers);
                    }
                    catch (GridDhtInvalidPartitionException entry) {
                    }
                    catch (IgniteCheckedException e) {
                        U.error(this.log, "Failed to clear cache entry: " + key, e);
                    }
                }
                finally {
                    cctx.shared().database().checkpointReadUnlock();
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to close iterator", e);
        }
    }

    @Override
    public int onUndeploy(ClassLoader ldr) {
        return 0;
    }

    @Override
    public long offHeapAllocatedSize() {
        return 0L;
    }

    @Override
    public <K, V> GridCloseableIterator<Cache.Entry<K, V>> cacheEntriesIterator(final GridCacheContext cctx, boolean primary, boolean backup, AffinityTopologyVersion topVer, final boolean keepBinary, Boolean dataPageScanEnabled) {
        final GridIterator<CacheDataRow> it = this.cacheIterator(cctx.cacheId(), primary, backup, topVer, dataPageScanEnabled);
        return new GridCloseableIteratorAdapter<Cache.Entry<K, V>>(){
            private CacheEntryImplEx next;

            @Override
            protected Cache.Entry<K, V> onNext() {
                CacheEntryImplEx ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            protected boolean onHasNext() {
                if (this.next != null) {
                    return true;
                }
                CacheSearchRow nextRow = null;
                if (it.hasNext()) {
                    nextRow = (CacheDataRow)it.next();
                }
                if (nextRow != null) {
                    KeyCacheObject key = nextRow.key();
                    CacheObject val = nextRow.value();
                    Object key0 = cctx.unwrapBinaryIfNeeded(key, keepBinary, false, null);
                    Object val0 = cctx.unwrapBinaryIfNeeded(val, keepBinary, false, null);
                    this.next = new CacheEntryImplEx<Object, Object>(key0, val0, nextRow.version());
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public GridCloseableIterator<KeyCacheObject> cacheKeysIterator(int cacheId, int part) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore data = this.dataStore(part, true);
        if (data == null) {
            return new GridEmptyCloseableIterator<KeyCacheObject>();
        }
        final GridCursor<? extends CacheDataRow> cur = data.cursor(cacheId, null, null, (Object)CacheDataRowAdapter.RowData.KEY_ONLY);
        return new GridCloseableIteratorAdapter<KeyCacheObject>(){
            private KeyCacheObject next;

            @Override
            protected KeyCacheObject onNext() {
                KeyCacheObject res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                if (cur.next()) {
                    CacheDataRow row = (CacheDataRow)cur.get();
                    this.next = row.key();
                }
                return this.next != null;
            }
        };
    }

    @Override
    public GridIterator<CacheDataRow> cacheIterator(int cacheId, boolean primary, boolean backups, AffinityTopologyVersion topVer, Boolean dataPageScanEnabled) {
        return this.iterator(cacheId, this.cacheData(primary, backups, topVer), dataPageScanEnabled);
    }

    @Override
    public GridIterator<CacheDataRow> cachePartitionIterator(int cacheId, int part, Boolean dataPageScanEnabled) {
        IgniteCacheOffheapManager.CacheDataStore data = this.dataStore(part, true);
        if (data == null) {
            return new GridEmptyCloseableIterator<CacheDataRow>();
        }
        return this.iterator(cacheId, this.singletonIterator(data), dataPageScanEnabled);
    }

    @Override
    public GridIterator<CacheDataRow> partitionIterator(int part) {
        IgniteCacheOffheapManager.CacheDataStore data = this.dataStore(part, true);
        if (data == null) {
            return new GridEmptyCloseableIterator<CacheDataRow>();
        }
        return this.iterator(0, this.singletonIterator(data), null);
    }

    private GridCloseableIterator<CacheDataRow> iterator(final int cacheId, final Iterator<IgniteCacheOffheapManager.CacheDataStore> dataIt, Boolean dataPageScanEnabled) {
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private GridCursor<? extends CacheDataRow> cur;
            private int curPart;
            private CacheDataRow next;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                try {
                    while (true) {
                        if (this.cur == null) {
                            if (!dataIt.hasNext()) break;
                            IgniteCacheOffheapManager.CacheDataStore ds = (IgniteCacheOffheapManager.CacheDataStore)dataIt.next();
                            this.curPart = ds.partId();
                            CacheDataTree.setDataPageScanEnabled(false);
                            try {
                                this.cur = cacheId == 0 ? ds.cursor() : ds.cursor(cacheId);
                            }
                            finally {
                                CacheDataTree.setDataPageScanEnabled(false);
                            }
                        }
                        if (this.cur.next()) {
                            this.next = this.cur.get();
                            this.next.key().partition(this.curPart);
                            break;
                        }
                        this.cur = null;
                    }
                }
                catch (IgniteCheckedException ex) {
                    throw new IgniteCheckedException("Failed to get next data row due to underlying cursor invalidation", ex);
                }
                return this.next != null;
            }
        };
    }

    private GridCloseableIterator<CacheDataRow> evictionSafeIterator(final int cacheId, final Iterator<IgniteCacheOffheapManager.CacheDataStore> dataIt) {
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private GridCursor<? extends CacheDataRow> cur;
            private GridDhtLocalPartition curPart;
            private CacheDataRow next;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                if (this.next != null) {
                    return true;
                }
                while (true) {
                    if (this.cur == null) {
                        if (!dataIt.hasNext()) break;
                        IgniteCacheOffheapManager.CacheDataStore ds = (IgniteCacheOffheapManager.CacheDataStore)dataIt.next();
                        if (!this.reservePartition(ds.partId())) continue;
                        GridCursor<? extends CacheDataRow> gridCursor = this.cur = cacheId == 0 ? ds.cursor() : ds.cursor(cacheId);
                    }
                    if (this.cur.next()) {
                        this.next = this.cur.get();
                        this.next.key().partition(this.curPart.id());
                        break;
                    }
                    this.cur = null;
                    this.releaseCurrentPartition();
                }
                return this.next != null;
            }

            private void releaseCurrentPartition() {
                GridDhtLocalPartition p = this.curPart;
                assert (p != null);
                this.curPart = null;
                p.release();
            }

            private boolean reservePartition(int partId) {
                GridDhtLocalPartition p = IgniteCacheOffheapManagerImpl.this.grp.topology().localPartition(partId);
                if (p != null && p.reserve()) {
                    this.curPart = p;
                    return true;
                }
                return false;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                if (this.curPart != null) {
                    this.releaseCurrentPartition();
                }
            }
        };
    }

    private <T> Iterator<T> singletonIterator(final T item) {
        return new Iterator<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public T next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return item;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private long allocateForTree() throws IgniteCheckedException {
        long pageId;
        ReuseList reuseList = this.grp.reuseList();
        if (reuseList == null || (pageId = reuseList.takeRecycledPage()) == 0L) {
            pageId = this.grp.dataRegion().pageMemory().allocatePage(this.grp.groupId(), 65535, (byte)2);
        }
        return pageId;
    }

    @Override
    public RootPage rootPageForIndex(int cacheId, String idxName, int segment) throws IgniteCheckedException {
        long pageId = this.allocateForTree();
        return new RootPage(new FullPageId(pageId, this.grp.groupId()), true);
    }

    @Override
    @Nullable
    public RootPage findRootPageForIndex(int cacheId, String idxName, int segment) throws IgniteCheckedException {
        return null;
    }

    @Override
    @Nullable
    public RootPage dropRootPageForIndex(int cacheId, String idxName, int segment) throws IgniteCheckedException {
        return null;
    }

    @Override
    @Nullable
    public RootPage renameRootPageForIndex(int cacheId, String oldIdxName, String newIdxName, int segment) throws IgniteCheckedException {
        return null;
    }

    @Override
    public ReuseList reuseListForIndex(String idxName) {
        return this.grp.reuseList();
    }

    @Override
    public GridCloseableIterator<CacheDataRow> reservedIterator(int part, AffinityTopologyVersion topVer) {
        final GridDhtLocalPartition loc = this.grp.topology().localPartition(part, topVer, false);
        if (loc == null || !loc.reserve()) {
            return null;
        }
        if (loc.state() != GridDhtPartitionState.OWNING) {
            loc.release();
            return null;
        }
        final IgniteCacheOffheapManager.CacheDataStore data = this.dataStore(loc);
        return new GridCloseableIteratorAdapter<CacheDataRow>(){
            private CacheDataRow next;
            private GridCursor<? extends CacheDataRow> cur;

            @Override
            protected CacheDataRow onNext() {
                CacheDataRow res = this.next;
                this.next = null;
                return res;
            }

            @Override
            protected boolean onHasNext() throws IgniteCheckedException {
                boolean hasNext;
                if (this.cur == null) {
                    this.cur = data.cursor();
                }
                if (this.next != null) {
                    return true;
                }
                if (this.cur.next()) {
                    this.next = this.cur.get();
                }
                boolean bl = hasNext = this.next != null;
                if (!hasNext) {
                    this.cur = null;
                }
                return hasNext;
            }

            @Override
            protected void onClose() throws IgniteCheckedException {
                assert (loc != null && loc.state() == GridDhtPartitionState.OWNING && loc.reservations() > 0) : "Partition should be in OWNING state and has at least 1 reservation: " + loc;
                loc.release();
                this.cur = null;
            }
        };
    }

    @Override
    public IgniteRebalanceIterator rebalanceIterator(IgniteDhtDemandedPartitionsMap parts, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        TreeMap<Integer, GridCloseableIterator<CacheDataRow>> iterators = new TreeMap<Integer, GridCloseableIterator<CacheDataRow>>();
        HashSet<Integer> missing = new HashSet<Integer>();
        for (Integer p : parts.fullSet()) {
            GridCloseableIterator<CacheDataRow> partIter = this.reservedIterator(p, topVer);
            if (partIter == null) {
                missing.add(p);
                continue;
            }
            iterators.put(p, partIter);
        }
        IgniteHistoricalIterator historicalIter = this.historicalIterator(parts.historicalMap(), missing);
        IgniteRebalanceIteratorImpl iter = new IgniteRebalanceIteratorImpl(iterators, historicalIter);
        for (Integer p : missing) {
            iter.setPartitionMissing(p);
        }
        return iter;
    }

    @Nullable
    protected IgniteHistoricalIterator historicalIterator(CachePartitionPartialCountersMap partCntrs, Set<Integer> missing) throws IgniteCheckedException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeEntries(GridDhtLocalPartition part, Iterator<GridCacheEntryInfo> infos, IgnitePredicateX<CacheDataRow> initPred) throws IgniteCheckedException {
        IgniteCacheOffheapManager.CacheDataStore dataStore = this.dataStore(part);
        ArrayList<DataRowCacheAware> batch = new ArrayList<DataRowCacheAware>(100);
        while (infos.hasNext()) {
            GridCacheEntryInfo info = infos.next();
            assert (info.ttl() == 0L) : info.ttl();
            batch.add(new DataRowCacheAware(info.key(), info.value(), info.version(), part.id(), info.expireTime(), info.cacheId(), this.grp.storeCacheIdInDataPage()));
            if (batch.size() != 100 && infos.hasNext()) continue;
            this.ctx.database().checkpointReadLock();
            try {
                dataStore.insertRows(batch, initPred);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
            batch.clear();
        }
    }

    @Override
    public final IgniteCacheOffheapManager.CacheDataStore createCacheDataStore(int p) throws IgniteCheckedException {
        this.partStoreLock.lock(p);
        try {
            IgniteCacheOffheapManager.CacheDataStore cacheDataStore = this.createCacheDataStore0(p);
            return cacheDataStore;
        }
        finally {
            this.partStoreLock.unlock(p);
        }
    }

    protected IgniteCacheOffheapManager.CacheDataStore createCacheDataStore0(int p) throws IgniteCheckedException {
        long rootPage = this.allocateForTree();
        CacheDataRowStore rowStore = new CacheDataRowStore(this.grp, this.grp.freeList(), p);
        String dataTreeName = this.grp.cacheOrGroupName() + "-" + this.treeName(p);
        CacheDataTree dataTree = new CacheDataTree(this.grp, dataTreeName, this.grp.reuseList(), rowStore, rootPage, true, this.ctx.diagnostic().pageLockTracker(), 2);
        return new CacheDataStoreImpl(p, rowStore, dataTree, () -> this.pendingEntries, this.grp, this.busyLock, this.log, null);
    }

    @Override
    public final void destroyCacheDataStore(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        int p = store.partId();
        this.partStoreLock.lock(p);
        try {
            if (store.destroyed()) {
                return;
            }
            this.destroyCacheDataStore0(store);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
        finally {
            this.partStoreLock.unlock(p);
        }
    }

    protected void destroyCacheDataStore0(IgniteCacheOffheapManager.CacheDataStore store) throws IgniteCheckedException {
        store.destroy();
    }

    protected final String treeName(int p) {
        return BPlusTree.treeName("p-" + p, "CacheData");
    }

    @Override
    public boolean expire(GridCacheContext cctx, IgniteInClosure2X<GridCacheEntryEx, GridCacheVersion> c, int amount) throws IgniteCheckedException {
        assert (!cctx.isNear()) : cctx.name();
        assert (this.pendingEntries != null);
        int cleared = this.expireInternal(cctx, c, amount);
        return amount != -1 && cleared >= amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int expireInternal(GridCacheContext cctx, IgniteInClosure2X<GridCacheEntryEx, GridCacheVersion> c, int amount) throws IgniteCheckedException {
        GridCacheVersion obsoleteVer = null;
        cctx.shared().database().checkpointReadLock();
        try {
            int cacheId;
            int n = cacheId = this.grp.sharedGroup() ? cctx.cacheId() : 0;
            if (!this.busyLock.enterBusy()) {
                int n2 = 0;
                return n2;
            }
            try {
                List<PendingRow> rows;
                int cleared = 0;
                while (!(rows = this.pendingEntries.remove(new PendingRow(cacheId, Long.MIN_VALUE, 0L), new PendingRow(cacheId, U.currentTimeMillis(), 0L), amount - cleared)).isEmpty()) {
                    for (PendingRow row : rows) {
                        GridCacheEntryEx entry;
                        if (row.key.partition() == -1) {
                            row.key.partition(cctx.affinity().partition(row.key));
                        }
                        assert (row.key != null && row.link != 0L && row.expireTime != 0L) : row;
                        if (obsoleteVer == null) {
                            obsoleteVer = cctx.cache().nextVersion();
                        }
                        if ((entry = cctx.cache().entryEx(row.key instanceof KeyCacheObjectImpl ? new ExpiredKeyCacheObject((KeyCacheObjectImpl)row.key, row.expireTime, row.link) : row.key)) == null) continue;
                        c.apply(entry, obsoleteVer);
                    }
                    if (amount < 0 || (cleared += rows.size()) < amount) continue;
                }
                int n3 = cleared;
                this.busyLock.leaveBusy();
                return n3;
            }
            catch (Throwable throwable) {
                this.busyLock.leaveBusy();
                throw throwable;
            }
        }
        finally {
            cctx.shared().database().checkpointReadUnlock();
        }
    }

    @Override
    public long expiredSize() throws IgniteCheckedException {
        return this.pendingEntries != null ? this.pendingEntries.size() : 0L;
    }

    @Override
    public boolean hasEntriesPendingExpire(int cacheId) throws IgniteCheckedException {
        if (this.pendingEntries == null) {
            return false;
        }
        if (this.grp.sharedGroup()) {
            PendingRow row = new PendingRow(cacheId);
            GridCursor cursor = this.pendingEntries.find(row, row, PendingEntriesTree.WITHOUT_KEY);
            return cursor.next();
        }
        return !this.pendingEntries.isEmpty();
    }

    protected static class ExpiredKeyCacheObject
    extends KeyCacheObjectImpl {
        private static final long serialVersionUID = 0L;
        private long expireTime;
        private long link;

        public ExpiredKeyCacheObject(KeyCacheObjectImpl keyCacheObj, long expireTime, long link) {
            super(keyCacheObj.val, keyCacheObj.valBytes, keyCacheObj.partition());
            this.expireTime = expireTime;
            this.link = link;
        }

        public ExpiredKeyCacheObject() {
        }
    }

    public static class CacheDataStoreImpl
    implements IgniteCacheOffheapManager.CacheDataStore {
        private final int partId;
        private final CacheDataRowStore rowStore;
        private final CacheDataTree dataTree;
        private final Supplier<PendingEntriesTree> pendingEntries;
        private final CacheGroupContext grp;
        private final GridSpinBusyLock busyLock;
        protected final PartitionUpdateCounter pCntr;
        private final LongAdder storageSize = new LongAdder();
        private final IntMap<AtomicLong> cacheSizes = new IntRWHashMap<AtomicLong>();
        private final IgniteLogger log;
        private final Boolean failNodeOnPartitionInconsistency = Boolean.getBoolean("IGNITE_FAIL_NODE_ON_UNRECOVERABLE_PARTITION_INCONSISTENCY");
        private final int updateValSizeThreshold;
        private volatile GridQueryRowCacheCleaner rowCacheCleaner;

        public CacheDataStoreImpl(int partId, CacheDataRowStore rowStore, CacheDataTree dataTree, Supplier<PendingEntriesTree> pendingEntries, CacheGroupContext grp, GridSpinBusyLock busyLock, IgniteLogger log, @Nullable Supplier<GridQueryRowCacheCleaner> cleaner) {
            this.partId = partId;
            this.rowStore = rowStore;
            this.dataTree = dataTree;
            this.pendingEntries = pendingEntries;
            this.grp = grp;
            this.busyLock = busyLock;
            this.log = log;
            PartitionUpdateCounter delegate = !grp.persistenceEnabled() || grp.hasAtomicCaches() ? new PartitionUpdateCounterVolatileImpl(grp) : new PartitionUpdateCounterTrackingImpl(grp);
            this.pCntr = grp.shared().logger(PartitionUpdateCounterDebugWrapper.class).isDebugEnabled() ? new PartitionUpdateCounterDebugWrapper(partId, delegate) : new PartitionUpdateCounterErrorWrapper(partId, delegate);
            this.updateValSizeThreshold = grp.shared().database().pageSize() / 2;
            if (cleaner == null) {
                rowStore.setRowCacheCleaner(() -> this.rowCacheCleaner);
            } else {
                rowStore.setRowCacheCleaner(cleaner);
            }
        }

        @Override
        public CacheDataTree tree() {
            return this.dataTree;
        }

        void incrementSize(int cacheId) {
            this.updateSize(cacheId, 1L);
        }

        void decrementSize(int cacheId) {
            this.updateSize(cacheId, -1L);
        }

        @Override
        public boolean init() {
            return false;
        }

        @Override
        public int partId() {
            return this.partId;
        }

        @Override
        public long cacheSize(int cacheId) {
            if (this.grp.sharedGroup()) {
                AtomicLong size = this.cacheSizes.get(cacheId);
                return size != null ? (long)((int)size.get()) : 0L;
            }
            return this.storageSize.sum();
        }

        @Override
        public Map<Integer, Long> cacheSizes() {
            if (!this.grp.sharedGroup()) {
                return null;
            }
            HashMap<Integer, Long> res = new HashMap<Integer, Long>();
            this.cacheSizes.forEach((key, val) -> res.put(key, val.longValue()));
            return res;
        }

        @Override
        public long fullSize() {
            return this.storageSize.sum();
        }

        @Override
        public boolean isEmpty() {
            return this.storageSize.sum() == 0L;
        }

        @Override
        public void updateSize(int cacheId, long delta) {
            this.storageSize.add(delta);
            if (this.grp.sharedGroup()) {
                AtomicLong old;
                AtomicLong size = this.cacheSizes.get(cacheId);
                if (size == null && (old = this.cacheSizes.putIfAbsent(cacheId, size = new AtomicLong())) != null) {
                    size = old;
                }
                size.addAndGet(delta);
            }
        }

        @Override
        public long nextUpdateCounter() {
            return this.pCntr.next();
        }

        @Override
        public long initialUpdateCounter() {
            return this.pCntr.initial();
        }

        @Override
        public void updateInitialCounter(long start, long delta) {
            this.pCntr.updateInitial(start, delta);
        }

        @Override
        public long getAndIncrementUpdateCounter(long delta) {
            return this.pCntr.reserve(delta);
        }

        @Override
        public long updateCounter() {
            return this.pCntr.get();
        }

        @Override
        public long highestAppliedCounter() {
            return this.pCntr.highestAppliedCounter();
        }

        @Override
        public long reservedCounter() {
            return this.pCntr.reserved();
        }

        @Override
        public PartitionUpdateCounter partUpdateCounter() {
            return this.pCntr;
        }

        @Override
        public long reserve(long delta) {
            return this.pCntr.reserve(delta);
        }

        @Override
        public void updateCounter(long val) {
            block2: {
                try {
                    this.pCntr.update(val);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to update partition counter. Most probably a node with most actual data is out of topology or data streamer is used in preload mode (allowOverride=false) concurrently with cache transactions [grpName=" + this.grp.cacheOrGroupName() + ", partId=" + this.partId + "]", e);
                    if (!this.failNodeOnPartitionInconsistency.booleanValue()) break block2;
                    this.grp.shared().kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, e));
                }
            }
        }

        @Override
        public boolean updateCounter(long start, long delta) {
            return this.pCntr.update(start, delta);
        }

        @Override
        public GridLongList finalizeUpdateCounters() {
            return this.pCntr.finalizeUpdateCounters();
        }

        private boolean canUpdateOldRow(GridCacheContext cctx, @Nullable CacheDataRow oldRow, DataRow dataRow) throws IgniteCheckedException {
            if (oldRow == null || cctx.queries().enabled()) {
                return false;
            }
            if (oldRow.expireTime() != dataRow.expireTime()) {
                return false;
            }
            int oldLen = oldRow.size();
            if (!this.grp.storeCacheIdInDataPage() && this.grp.sharedGroup() && oldRow.cacheId() != 0) {
                oldLen -= 4;
            }
            if (oldLen > this.updateValSizeThreshold) {
                return false;
            }
            int newLen = dataRow.size();
            return oldLen == newLen;
        }

        private IgniteCheckedException operationCancelledException() {
            if (this.grp.isPreparedToStop()) {
                return new IgniteCheckedException("Operation has been cancelled (cache group: " + this.grp.cacheOrGroupName() + " is stopping).");
            }
            return new NodeStoppingException("Operation has been cancelled (node is stopping).");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(GridCacheContext cctx, KeyCacheObject key, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
            if (!this.busyLock.enterBusy()) {
                throw this.operationCancelledException();
            }
            int cacheId = this.grp.sharedGroup() ? cctx.cacheId() : 0;
            try {
                this.invoke0(cctx, new SearchRow(cacheId, key), c);
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }

        private void invoke0(GridCacheContext cctx, CacheSearchRow row, IgniteCacheOffheapManager.OffheapInvokeClosure c) throws IgniteCheckedException {
            assert (cctx.shared().database().checkpointLockIsHeldByThread());
            this.dataTree.invoke(row, (Object)CacheDataRowAdapter.RowData.NO_KEY, c);
            switch (c.operationType()) {
                case PUT: {
                    assert (c.newRow() != null) : c;
                    CacheDataRow oldRow = c.oldRow();
                    this.finishUpdate(cctx, (CacheDataRow)c.newRow(), oldRow, c.oldRowExpiredFlag());
                    break;
                }
                case REMOVE: {
                    CacheDataRow oldRow = c.oldRow();
                    this.finishRemove(cctx, row.key(), oldRow);
                    break;
                }
                case NOOP: 
                case IN_PLACE: {
                    break;
                }
                default: {
                    assert (false) : c.operationType();
                    break;
                }
            }
        }

        @Override
        public CacheDataRow createRow(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            int cacheId = this.grp.storeCacheIdInDataPage() ? cctx.cacheId() : 0;
            DataRow dataRow = this.makeDataRow(key, val, ver, expireTime, cacheId);
            if (this.canUpdateOldRow(cctx, oldRow, dataRow) && this.rowStore.updateRow(oldRow.link(), dataRow, this.grp.statisticsHolderData())) {
                dataRow.link(oldRow.link());
            } else {
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                val.valueBytes(coCtx);
                this.rowStore.addRow(dataRow, this.grp.statisticsHolderData());
            }
            assert (dataRow.link() != 0L) : dataRow;
            if (this.grp.sharedGroup() && dataRow.cacheId() == 0) {
                dataRow.cacheId(cctx.cacheId());
            }
            return dataRow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRows(Collection<DataRowCacheAware> rows, IgnitePredicateX<CacheDataRow> initPred) throws IgniteCheckedException {
            if (!this.busyLock.enterBusy()) {
                throw this.operationCancelledException();
            }
            try {
                this.rowStore.addRows(F.view(rows, row -> row.value() != null), this.grp.statisticsHolderData());
                boolean cacheIdAwareGrp = this.grp.sharedGroup() || this.grp.storeCacheIdInDataPage();
                for (DataRowCacheAware row2 : rows) {
                    row2.storeCacheId(cacheIdAwareGrp);
                    if (initPred.applyx(row2) || row2.value() == null) continue;
                    this.rowStore.removeRow(row2.link(), this.grp.statisticsHolderData());
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }

        @NotNull
        private DataRow makeDataRow(KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, int cacheId) {
            if (key.partition() == -1) {
                key.partition(this.partId);
            }
            return new DataRow(key, val, ver, this.partId, expireTime, cacheId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(GridCacheContext cctx, KeyCacheObject key, CacheObject val, GridCacheVersion ver, long expireTime, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            assert (oldRow == null || oldRow.link() != 0L) : oldRow;
            if (!this.busyLock.enterBusy()) {
                throw this.operationCancelledException();
            }
            try {
                CacheDataRow old;
                int cacheId;
                int n = cacheId = this.grp.storeCacheIdInDataPage() ? cctx.cacheId() : 0;
                assert (oldRow == null || oldRow.cacheId() == cacheId) : oldRow;
                DataRow dataRow = this.makeDataRow(key, val, ver, expireTime, cacheId);
                CacheObjectContext coCtx = cctx.cacheObjectContext();
                key.valueBytes(coCtx);
                val.valueBytes(coCtx);
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                if (this.canUpdateOldRow(cctx, oldRow, dataRow) && this.rowStore.updateRow(oldRow.link(), dataRow, this.grp.statisticsHolderData())) {
                    old = oldRow;
                    dataRow.link(oldRow.link());
                } else {
                    this.rowStore.addRow(dataRow, this.grp.statisticsHolderData());
                    assert (dataRow.link() != 0L) : dataRow;
                    if (this.grp.sharedGroup() && dataRow.cacheId() == 0) {
                        dataRow.cacheId(cctx.cacheId());
                    }
                    if (oldRow != null) {
                        old = oldRow;
                        this.dataTree.putx(dataRow);
                    } else {
                        old = this.dataTree.put(dataRow);
                    }
                }
                this.finishUpdate(cctx, dataRow, old);
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }

        private void finishUpdate(GridCacheContext cctx, CacheDataRow newRow, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            this.finishUpdate(cctx, newRow, oldRow, false);
        }

        private void finishUpdate(GridCacheContext cctx, CacheDataRow newRow, @Nullable CacheDataRow oldRow, boolean oldRowExpired) throws IgniteCheckedException {
            GridCacheQueryManager qryMgr;
            if (oldRow == null && !oldRowExpired) {
                this.incrementSize(cctx.cacheId());
            }
            if ((qryMgr = cctx.queries()).enabled()) {
                qryMgr.store(newRow, oldRow, true);
            }
            this.updatePendingEntries(cctx, newRow, oldRow);
            if (oldRow != null) {
                assert (oldRow.link() != 0L) : oldRow;
                if (newRow.link() != oldRow.link()) {
                    this.rowStore.removeRow(oldRow.link(), this.grp.statisticsHolderData());
                }
            }
        }

        private void updatePendingEntries(GridCacheContext cctx, CacheDataRow newRow, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            int cacheId;
            long expireTime = newRow.expireTime();
            int n = cacheId = this.grp.sharedGroup() ? cctx.cacheId() : 0;
            if (oldRow != null) {
                assert (oldRow.link() != 0L) : oldRow;
                if (this.pendingTree() != null && oldRow.expireTime() != 0L) {
                    this.pendingTree().removex(new PendingRow(cacheId, oldRow.expireTime(), oldRow.link()));
                }
            }
            if (this.pendingTree() != null && expireTime != 0L) {
                this.pendingTree().putx(new PendingRow(cacheId, expireTime, newRow.link()));
                if (!cctx.ttl().hasPendingEntries()) {
                    cctx.ttl().hasPendingEntries(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(GridCacheContext cctx, KeyCacheObject key, int partId) throws IgniteCheckedException {
            if (!this.busyLock.enterBusy()) {
                throw this.operationCancelledException();
            }
            try {
                int cacheId;
                int n = cacheId = this.grp.sharedGroup() ? cctx.cacheId() : 0;
                assert (cctx.shared().database().checkpointLockIsHeldByThread());
                CacheDataRow oldRow = (CacheDataRow)this.dataTree.remove(new SearchRow(cacheId, key));
                this.finishRemove(cctx, key, oldRow);
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }

        private void finishRemove(GridCacheContext cctx, KeyCacheObject key, @Nullable CacheDataRow oldRow) throws IgniteCheckedException {
            GridCacheQueryManager qryMgr;
            if (oldRow != null) {
                if (!(key instanceof ExpiredKeyCacheObject) || ((ExpiredKeyCacheObject)key).expireTime != oldRow.expireTime() || ((ExpiredKeyCacheObject)key).link != oldRow.link()) {
                    this.clearPendingEntries(cctx, oldRow);
                }
                this.decrementSize(cctx.cacheId());
            }
            if ((qryMgr = cctx.queries()).enabled()) {
                qryMgr.remove(key, oldRow);
            }
            if (oldRow != null) {
                this.rowStore.removeRow(oldRow.link(), this.grp.statisticsHolderData());
            }
        }

        private void clearPendingEntries(GridCacheContext cctx, CacheDataRow oldRow) throws IgniteCheckedException {
            int cacheId;
            int n = cacheId = this.grp.sharedGroup() ? cctx.cacheId() : 0;
            assert (oldRow.link() != 0L) : oldRow;
            assert (cacheId == 0 || oldRow.cacheId() == cacheId) : "Incorrect cache ID [expected=" + cacheId + ", actual=" + oldRow.cacheId() + "].";
            if (this.pendingTree() != null && oldRow.expireTime() != 0L) {
                this.pendingTree().removex(new PendingRow(cacheId, oldRow.expireTime(), oldRow.link()));
            }
        }

        @Override
        public CacheDataRow find(GridCacheContext cctx, KeyCacheObject key) throws IgniteCheckedException {
            key.valueBytes(cctx.cacheObjectContext());
            int cacheId = this.grp.sharedGroup() ? cctx.cacheId() : 0;
            CacheDataRow row = (CacheDataRow)this.dataTree.findOne(new SearchRow(cacheId, key), (Object)CacheDataRowAdapter.RowData.NO_KEY);
            this.afterRowFound(row, key);
            return row;
        }

        private void afterRowFound(@Nullable CacheDataRow row, KeyCacheObject key) throws IgniteCheckedException {
            if (row != null) {
                row.key(key);
                this.grp.dataRegion().evictionTracker().touchPage(row.link());
            }
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor() throws IgniteCheckedException {
            return this.dataTree.find(null, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(Object x) throws IgniteCheckedException {
            return this.dataTree.find(null, null, x);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId) throws IgniteCheckedException {
            return this.cursor(cacheId, null, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper) throws IgniteCheckedException {
            return this.cursor(cacheId, lower, upper, null);
        }

        @Override
        public GridCursor<? extends CacheDataRow> cursor(int cacheId, KeyCacheObject lower, KeyCacheObject upper, Object x) throws IgniteCheckedException {
            SearchRow upperRow;
            SearchRow lowerRow;
            if (this.grp.sharedGroup()) {
                assert (cacheId != 0);
                lowerRow = lower != null ? new SearchRow(cacheId, lower) : new SearchRow(cacheId);
                upperRow = upper != null ? new SearchRow(cacheId, upper) : new SearchRow(cacheId);
            } else {
                lowerRow = lower != null ? new SearchRow(0, lower) : null;
                upperRow = upper != null ? new SearchRow(0, upper) : null;
            }
            return this.dataTree.find(lowerRow, upperRow, x);
        }

        @Override
        public void destroy() throws IgniteCheckedException {
            AtomicReference exRef = new AtomicReference();
            this.dataTree.destroy(row -> {
                try {
                    this.rowStore.removeRow(row.link(), this.grp.statisticsHolderData());
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Failed to remove row [link=" + row.link() + "]");
                    IgniteCheckedException ex = (IgniteCheckedException)exRef.get();
                    if (ex == null) {
                        exRef.set(e);
                    }
                    ex.addSuppressed(e);
                }
            }, false);
            if (exRef.get() != null) {
                throw new IgniteCheckedException("Failed to destroy store", (Throwable)exRef.get());
            }
        }

        @Override
        public void markDestroyed() {
            this.dataTree.markDestroyed();
        }

        @Override
        public boolean destroyed() {
            return this.dataTree.destroyed();
        }

        @Override
        public void clear(int cacheId) throws IgniteCheckedException {
            assert (cacheId != 0);
            if (this.cacheSize(cacheId) == 0L) {
                return;
            }
            IgniteCheckedException ex = null;
            GridCursor<? extends CacheDataRow> cur = this.cursor(cacheId, null, null, (Object)CacheDataRowAdapter.RowData.KEY_ONLY);
            int rmv = 0;
            while (cur.next()) {
                if (++rmv == 1000) {
                    this.grp.shared().database().checkpointReadUnlock();
                    rmv = 0;
                    this.grp.shared().database().checkpointReadLock();
                }
                CacheDataRow row = cur.get();
                assert (row.link() != 0L) : row;
                try {
                    boolean res = this.dataTree.removex(row);
                    assert (res) : row;
                    this.rowStore.removeRow(row.link(), this.grp.statisticsHolderData());
                    this.decrementSize(cacheId);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Fail remove row [link=" + row.link() + "]");
                    if (ex == null) {
                        ex = e;
                        continue;
                    }
                    ex.addSuppressed(e);
                }
            }
            if (ex != null) {
                throw new IgniteCheckedException("Fail destroy store", ex);
            }
            this.grp.shared().database().checkpointReadUnlock();
            this.grp.shared().database().checkpointReadLock();
        }

        @Override
        public RowStore rowStore() {
            return this.rowStore;
        }

        @Override
        public void setRowCacheCleaner(GridQueryRowCacheCleaner rowCacheCleaner) {
            this.rowCacheCleaner = rowCacheCleaner;
        }

        public void restoreState(long size, long updCntr, @Nullable Map<Integer, Long> cacheSizes, byte[] cntrUpdData) {
            this.pCntr.init(updCntr, cntrUpdData);
            this.storageSize.reset();
            this.storageSize.add(size);
            if (cacheSizes != null) {
                for (Map.Entry<Integer, Long> e : cacheSizes.entrySet()) {
                    this.cacheSizes.put(e.getKey(), new AtomicLong(e.getValue()));
                }
            }
        }

        @Override
        public PendingEntriesTree pendingTree() {
            return this.pendingEntries.get();
        }

        @Override
        public void preload() throws IgniteCheckedException {
        }

        @Override
        public void resetUpdateCounter() {
            this.pCntr.reset();
        }

        @Override
        public void resetInitialUpdateCounter() {
            this.pCntr.resetInitialCounter();
        }

        @Override
        public PartitionMetaStorage<SimpleDataRow> partStorage() {
            return null;
        }
    }
}

