/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.bulkload;

import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.internal.processors.bulkload.BulkLoadCacheWriter;
import org.apache.ignite.internal.processors.bulkload.BulkLoadParser;
import org.apache.ignite.internal.processors.query.running.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.running.RunningQueryManager;
import org.apache.ignite.internal.processors.tracing.MTC;
import org.apache.ignite.internal.processors.tracing.NoopSpan;
import org.apache.ignite.internal.processors.tracing.Span;
import org.apache.ignite.internal.processors.tracing.SpanType;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.lang.IgniteClosureX;
import org.apache.ignite.lang.IgniteBiTuple;

public class BulkLoadProcessor
implements AutoCloseable {
    private final BulkLoadParser inputParser;
    private final IgniteClosureX<List<?>, IgniteBiTuple<?, ?>> dataConverter;
    private final BulkLoadCacheWriter outputStreamer;
    private boolean isClosed;
    private final RunningQueryManager runningQryMgr;
    private final long qryId;
    private Exception failReason;
    private final Tracing tracing;
    private final Span qrySpan;

    public BulkLoadProcessor(BulkLoadParser inputParser, IgniteClosureX<List<?>, IgniteBiTuple<?, ?>> dataConverter, BulkLoadCacheWriter outputStreamer, RunningQueryManager runningQryMgr, long qryId, Tracing tracing) {
        this.inputParser = inputParser;
        this.dataConverter = dataConverter;
        this.outputStreamer = outputStreamer;
        this.runningQryMgr = runningQryMgr;
        this.qryId = qryId;
        this.tracing = tracing;
        GridRunningQueryInfo qryInfo = runningQryMgr.runningQueryInfo(qryId);
        this.qrySpan = qryInfo == null ? NoopSpan.INSTANCE : qryInfo.span();
        this.isClosed = false;
    }

    public BulkLoadCacheWriter outputStreamer() {
        return this.outputStreamer;
    }

    public void processBatch(byte[] batchData, boolean isLastBatch) throws IgniteCheckedException {
        try (MTC.TraceSurroundings ignored = MTC.support(this.tracing.create(SpanType.SQL_BATCH_PROCESS, this.qrySpan));){
            if (this.isClosed) {
                throw new IgniteIllegalStateException("Attempt to process a batch on a closed BulkLoadProcessor");
            }
            Iterable<List<Object>> inputRecords = this.inputParser.parseBatch(batchData, isLastBatch);
            for (List<Object> record : inputRecords) {
                IgniteBiTuple<?, ?> kv = this.dataConverter.apply(record);
                this.outputStreamer.apply(kv);
            }
        }
    }

    public void onError(Exception failReason) {
        this.failReason = failReason;
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed) {
            return;
        }
        try {
            this.isClosed = true;
            this.outputStreamer.close();
        }
        catch (Exception e) {
            if (this.failReason == null) {
                this.failReason = e;
            }
            throw e;
        }
        finally {
            this.runningQryMgr.unregister(this.qryId, this.failReason);
        }
    }
}

