/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.diagnostic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.management.diagnostic.Operation;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroup(value={"all", "nodes"}, onlyOneOf=true, optional=true)
public class DiagnosticPagelocksCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Argument(optional=true)
    @Positional
    @EnumDescription(names={"DUMP", "DUMP_LOG"}, descriptions={"Save page locks dump to file generated in IGNITE_HOME/work/diagnostic directory", "Print page locks dump to console"})
    private Operation operation = Operation.DUMP_LOG;
    @Argument(optional=true)
    private String path;
    @Argument(description="Run for all nodes")
    private boolean all;
    @Argument(description="Comma separated list of node ids or consistent ids", example="node_id1[,node_id2....node_idN]|consistend_id1[,consistent_id2,....,consistent_idN]")
    private String[] nodes;

    private void ensureOperationAndPath(Operation op, String path) {
        if (path != null && op == Operation.DUMP_LOG) {
            throw new IllegalArgumentException("Path can be specified only in DUMP mode.");
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeEnum(out, this.operation);
        U.writeString(out, this.path);
        out.writeBoolean(this.all);
        U.writeArray(out, this.nodes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.operation = U.readEnum(in, Operation.class);
        this.path = U.readString(in);
        this.all = in.readBoolean();
        this.nodes = U.readArray(in, String.class);
    }

    public String[] nodes() {
        return this.nodes;
    }

    public void nodes(String[] nodeIds) {
        this.nodes = nodeIds;
    }

    public Operation operation() {
        return this.operation;
    }

    public void operation(Operation op) {
        this.ensureOperationAndPath(op, this.path);
        this.operation = op;
    }

    public String path() {
        return this.path;
    }

    public void path(String path) {
        this.ensureOperationAndPath(this.operation, path);
        this.path = path;
    }

    public boolean all() {
        return this.all;
    }

    public void all(boolean all) {
        this.all = all;
    }
}

