/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.diagnostic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.diagnostic.ConnectivityResult;
import org.apache.ignite.internal.management.diagnostic.DiagnosticConnectivityCommandArg;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class ConnectivityTask
extends VisorMultiNodeTask<DiagnosticConnectivityCommandArg, Map<ClusterNode, ConnectivityResult>, ConnectivityResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<DiagnosticConnectivityCommandArg, ConnectivityResult> job(DiagnosticConnectivityCommandArg arg) {
        return new ConnectivityJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<ClusterNode, ConnectivityResult> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap<ClusterNode, ConnectivityResult> map = new HashMap<ClusterNode, ConnectivityResult>();
        results.forEach(result -> {
            if (result.getException() != null) {
                return;
            }
            ClusterNode node = result.getNode();
            ConnectivityResult data = (ConnectivityResult)result.getData();
            map.put(node, data);
        });
        return map;
    }

    @Override
    protected Collection<UUID> jobNodes(VisorTaskArgument<DiagnosticConnectivityCommandArg> arg) {
        return Arrays.asList(arg.getArgument().nodes());
    }

    private static class ConnectivityJob
    extends VisorJob<DiagnosticConnectivityCommandArg, ConnectivityResult> {
        private static final long serialVersionUID = 0L;

        private ConnectivityJob(DiagnosticConnectivityCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ConnectivityResult run(DiagnosticConnectivityCommandArg arg) {
            List<UUID> ids = this.ignite.cluster().nodes().stream().map(ClusterNode::id).filter(uuid -> !Objects.equals(this.ignite.localNode().id(), uuid)).collect(Collectors.toList());
            ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(this.ignite.cluster().forNodeIds(ids).nodes());
            CommunicationSpi spi = this.ignite.configuration().getCommunicationSpi();
            HashMap<ClusterNode, Boolean> statuses = new HashMap<ClusterNode, Boolean>();
            if (spi instanceof TcpCommunicationSpi) {
                BitSet set = ((TcpCommunicationSpi)spi).checkConnection(nodes).get();
                for (int i = 0; i < nodes.size(); ++i) {
                    ClusterNode node = (ClusterNode)nodes.get(i);
                    boolean success = set.get(i);
                    statuses.put(node, success);
                }
            }
            return new ConnectivityResult(statuses);
        }

        public String toString() {
            return S.toString(ConnectivityJob.class, this);
        }
    }
}

