/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.management.cache.ValidateIndexesJobResult;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.jetbrains.annotations.Nullable;

public class ValidateIndexesTaskResult
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Nullable
    private Map<NodeInfo, Exception> exceptions;
    @Nullable
    private Map<NodeInfo, ValidateIndexesJobResult> results;

    public void addResult(ClusterNode clusterNode, ValidateIndexesJobResult jobResult) {
        if (this.results == null) {
            this.results = new HashMap<NodeInfo, ValidateIndexesJobResult>();
        }
        this.results.put(new NodeInfo(clusterNode.id(), clusterNode.consistentId()), jobResult);
    }

    @Nullable
    public ValidateIndexesJobResult jobResult(ClusterNode clusterNode) {
        return this.results().get(new NodeInfo(clusterNode.id(), clusterNode.consistentId()));
    }

    public Map<NodeInfo, ValidateIndexesJobResult> results() {
        return this.results == null ? Collections.emptyMap() : this.results;
    }

    public void addException(ClusterNode clusterNode, Exception exception) {
        if (this.exceptions == null) {
            this.exceptions = new HashMap<NodeInfo, Exception>();
        }
        this.exceptions.put(new NodeInfo(clusterNode.id(), clusterNode.consistentId()), exception);
    }

    public Map<NodeInfo, Exception> exceptions() {
        return this.exceptions == null ? Collections.emptyMap() : this.exceptions;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, this.exceptions);
        U.writeMap(out, this.results);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.exceptions = U.readMap(in);
        this.results = U.readMap(in);
    }

    public String toString() {
        return S.toString(ValidateIndexesTaskResult.class, this);
    }

    public static final class NodeInfo
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final UUID id;
        private final Object consistentId;

        private NodeInfo(UUID id, Object consistentId) {
            assert (consistentId instanceof Serializable || consistentId instanceof Externalizable);
            this.id = id;
            this.consistentId = consistentId;
        }

        public UUID id() {
            return this.id;
        }

        public Object consistentId() {
            return this.consistentId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeInfo id1 = (NodeInfo)o;
            return this.id.equals(id1.id) && this.consistentId.equals(id1.consistentId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.consistentId);
        }
    }
}

