/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.ArgumentGroupsHolder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroupsHolder(value={@ArgumentGroup(value={"nodeIds", "allNodes", "nodeId"}, onlyOneOf=true, optional=true), @ArgumentGroup(value={"cacheNames", "groupNames"}, optional=false)})
public class CacheScheduleIndexesRebuildCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private static final String CACHE_NAMES_FORMAT = "cacheName[index1,...indexN],cacheName2,cacheName3[index1]";
    @Argument(description="(Optional) Specify node for indexes rebuild. If not specified, schedules rebuild on all nodes (deprecated. Use --node-ids or --all-nodes instead)", example="nodeId")
    private UUID nodeId;
    @Argument(description="Comma-separated list of nodes ids to schedule index rebuild on", example="nodeId1,...nodeIdN")
    private UUID[] nodeIds;
    @Argument(description="Rebuild index on all nodes")
    private boolean allNodes;
    @Argument(description="Comma-separated list of cache names with optionally specified indexes. If indexes are not specified then all indexes of the cache will be scheduled for the rebuild operation. Can be used simultaneously with cache group names", example="cacheName[index1,...indexN],cacheName2,cacheName3[index1]")
    private String cacheNames;
    @Argument(description="Comma-separated list of cache group names for which indexes should be scheduled for the rebuild. Can be used simultaneously with cache names", example="groupName1,groupName2,...groupNameN")
    private String[] groupNames;
    private Map<String, Set<String>> cacheToIndexes;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nodeId);
        U.writeString(out, this.cacheNames);
        U.writeArray(out, this.groupNames);
        U.writeMap(out, this.cacheToIndexes);
        U.writeArray(out, this.nodeIds);
        out.writeBoolean(this.allNodes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid(in);
        this.cacheNames = U.readString(in);
        this.groupNames = U.readArray(in, String.class);
        this.cacheToIndexes = U.readMap(in);
        this.nodeIds = U.readArray(in, UUID.class);
        this.allNodes = in.readBoolean();
    }

    private void parse() {
        this.cacheToIndexes = new HashMap<String, Set<String>>();
        Pattern cacheNamesPattern = Pattern.compile("([^,\\[\\]]+)(\\[(.*?)])?");
        Matcher matcher = cacheNamesPattern.matcher(this.cacheNames);
        boolean found = false;
        while (matcher.find()) {
            found = true;
            String cacheName = matcher.group(1);
            boolean specifiedIndexes = matcher.group(2) != null;
            String commaSeparatedIndexes = matcher.group(3);
            if (!specifiedIndexes) {
                this.cacheToIndexes.put(cacheName, Collections.emptySet());
                continue;
            }
            if (F.isEmpty(commaSeparatedIndexes)) {
                throw new IllegalArgumentException("Square brackets must contain comma-separated indexes or not be used at all.");
            }
            Set indexes = Arrays.stream(commaSeparatedIndexes.split(",")).collect(Collectors.toSet());
            this.cacheToIndexes.put(cacheName, indexes);
        }
        if (!found) {
            throw new IllegalArgumentException("Wrong format for --cache-names, should be: cacheName[index1,...indexN],cacheName2,cacheName3[index1]");
        }
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID[] nodeIds() {
        return this.nodeIds;
    }

    public void allNodes(boolean allNodes) {
        this.allNodes = allNodes;
    }

    public boolean allNodes() {
        return this.allNodes;
    }

    public void nodeIds(UUID[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public String cacheNames() {
        return this.cacheNames;
    }

    public void cacheNames(String cacheNames) {
        this.cacheNames = cacheNames;
        this.parse();
    }

    public String[] groupNames() {
        return this.groupNames;
    }

    public void groupNames(String[] groupNames) {
        this.groupNames = groupNames;
    }

    public Map<String, Set<String>> cacheToIndexes() {
        return this.cacheToIndexes;
    }

    public void cacheToIndexes(Map<String, Set<String>> cacheToIndexes) {
        this.cacheToIndexes = cacheToIndexes;
    }
}

