/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.api;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCacheMode;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientNodeMetrics;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.ArgumentGroupsHolder;
import org.apache.ignite.internal.management.api.BeforeNodeStartCommand;
import org.apache.ignite.internal.management.api.Command;
import org.apache.ignite.internal.management.api.CommandsRegistry;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.management.api.HelpCommand;
import org.apache.ignite.internal.management.api.LocalCommand;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.VisorTaskArgument;
import org.apache.ignite.internal.visor.VisorTaskResult;
import org.apache.ignite.lang.IgniteExperimental;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class CommandUtils {
    public static final String NAME_PREFIX = "--";
    public static final char CMD_WORDS_DELIM = '-';
    public static final char PARAM_WORDS_DELIM = '_';
    public static final String INDENT = "  ";
    public static final String DOUBLE_INDENT = "    ";

    public static String cmdText(Command<?, ?> cmd) {
        return NAME_PREFIX + CommandUtils.toFormattedCommandName(cmd.getClass(), '-');
    }

    public static String cmdKey(Class<?> cmdCls, Class<? extends CommandsRegistry<?, ?>> parent) {
        String name = cmdCls.getSimpleName();
        if (parent != null) {
            String parentName = parent.getSimpleName();
            if (!name.startsWith(parentName = parentName.substring(0, parentName.length() - "Command".length()))) {
                throw new IllegalArgumentException("Command class name must starts with parent name [parent=" + parentName + "]");
            }
            name = name.substring(parentName.length());
        }
        if (!name.endsWith("Command")) {
            throw new IllegalArgumentException("Command class name must ends with 'Command'");
        }
        return name.substring(0, name.length() - "Command".length());
    }

    public static String toFormattedCommandName(Class<?> cls) {
        return CommandUtils.toFormattedCommandName(cls, '-');
    }

    public static String toFormattedCommandName(Class<?> cls, char delim) {
        String name = cls.getSimpleName();
        return CommandUtils.toFormattedName(name.substring(0, name.length() - "Command".length()), delim);
    }

    public static String toFormattedFieldName(Field fld) {
        return (fld.getAnnotation(Argument.class).withoutPrefix() ? "" : NAME_PREFIX) + CommandUtils.toFormattedFieldName(fld, '-');
    }

    public static Set<String> toFormattedNames(Class<?> argCls, Set<String> flds) {
        return flds.stream().map(name -> U.findField(argCls, name)).map(CommandUtils::toFormattedFieldName).collect(Collectors.toSet());
    }

    static String toFormattedName(String name, char delim) {
        StringBuilder formatted = new StringBuilder();
        formatted.append(Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isLowerCase(name.charAt(i))) {
                formatted.append(name.charAt(i));
                continue;
            }
            formatted.append(delim);
            formatted.append(Character.toLowerCase(name.charAt(i)));
        }
        return formatted.toString();
    }

    public static String fromFormattedCommandName(String formatted, char delim) {
        StringBuilder name = new StringBuilder();
        name.append(Character.toUpperCase(formatted.charAt(0)));
        for (int i = 1; i < formatted.length(); ++i) {
            if (formatted.charAt(i) != delim) {
                name.append(Character.toLowerCase(formatted.charAt(i)));
                continue;
            }
            name.append(Character.toUpperCase(formatted.charAt(++i)));
        }
        return name.toString();
    }

    public static String parameterExample(Field fld, boolean appendOptional) {
        if (fld.isAnnotationPresent(Positional.class)) {
            Argument arg = fld.getAnnotation(Argument.class);
            return CommandUtils.asOptional(arg.example().isEmpty() ? CommandUtils.toFormattedFieldName(fld, '_') : arg.example(), appendOptional && arg.optional());
        }
        Argument param = fld.getAnnotation(Argument.class);
        String example = CommandUtils.valueExample(fld);
        return CommandUtils.asOptional(CommandUtils.toFormattedFieldName(fld) + (String)(example.isEmpty() ? "" : " " + example), appendOptional && param.optional());
    }

    public static String valueExample(Field fld) {
        boolean optional;
        if (CommandUtils.isBoolean(fld.getType())) {
            return "";
        }
        Argument param = fld.getAnnotation(Argument.class);
        boolean bl = optional = fld.isAnnotationPresent(Positional.class) && param.optional();
        if (!param.example().isEmpty()) {
            return CommandUtils.asOptional(param.example(), optional);
        }
        if (Enum.class.isAssignableFrom(fld.getType())) {
            ?[] vals = fld.getType().getEnumConstants();
            StringBuilder bldr = new StringBuilder();
            for (int i = 0; i < vals.length; ++i) {
                if (i != 0) {
                    bldr.append('|');
                }
                bldr.append(((Enum)vals[i]).name());
            }
            return CommandUtils.asOptional(bldr.toString(), optional);
        }
        Object name = CommandUtils.toFormattedFieldName(fld, '_');
        if (fld.getType().isArray() || Collection.class.isAssignableFrom(fld.getType())) {
            char last;
            if (((String)name).endsWith("s")) {
                name = ((String)name).substring(0, ((String)name).length() - 1);
            }
            if (Character.isUpperCase(last = ((String)name).charAt(((String)name).length() - 1))) {
                name = ((String)name).substring(0, ((String)name).length() - 1) + Character.toLowerCase(last);
            }
            String example = (String)name + "1[," + (String)name + "2,....," + (String)name + "N]";
            return CommandUtils.asOptional(example, optional);
        }
        return CommandUtils.asOptional((String)name, optional);
    }

    public static boolean isBoolean(Class<?> cls) {
        return cls == Boolean.class || cls == Boolean.TYPE;
    }

    private static String toFormattedFieldName(Field fld, char delim) {
        if (fld.isAnnotationPresent(Positional.class)) {
            return CommandUtils.toFormattedName(fld.getName(), delim);
        }
        return fld.getAnnotation(Argument.class).javaStyleName() ? fld.getName() : CommandUtils.toFormattedName(fld.getName(), delim);
    }

    public static String asOptional(String str, boolean optional) {
        return (optional ? "[" : "") + str + (optional ? "]" : "");
    }

    public static <T> T parseVal(String val, Class<T> type) {
        if (type.isArray() && type != char[].class) {
            String[] vals = val.split(",");
            Class<?> compType = type.getComponentType();
            if (compType == String.class) {
                return (T)vals;
            }
            Object res = Array.newInstance(compType, vals.length);
            for (int i = 0; i < vals.length; ++i) {
                Array.set(res, i, CommandUtils.parseSingleVal(vals[i], compType));
            }
            return (T)res;
        }
        return CommandUtils.parseSingleVal(val, type);
    }

    public static <A extends IgniteDataTransferObject> void visitCommandParams(Class<A> argCls, Consumer<Field> positionalParamVisitor, Consumer<Field> namedParamVisitor, BiConsumer<ArgumentGroup, List<Field>> argumentGroupVisitor) {
        int i;
        ArrayList<Class<A>> classes = new ArrayList<Class<A>>();
        for (Class<A> clazz0 = argCls; clazz0 != IgniteDataTransferObject.class; clazz0 = clazz0.getSuperclass()) {
            classes.add(clazz0);
        }
        ArrayList<Field> positionalParams = new ArrayList<Field>();
        ArrayList<Field> namedParams = new ArrayList<Field>();
        List<ArgumentGroup> argGprs = CommandUtils.argumentGroups(argCls);
        List<Set<String>> grpNames = CommandUtils.argumentGroupsValues(argGprs);
        ArrayList grpFlds = grpNames.isEmpty() ? Collections.emptyList() : new ArrayList(grpNames.size());
        grpNames.forEach(gf -> grpFlds.add(grpFlds.size(), null));
        for (i = classes.size() - 1; i >= 0; --i) {
            Field[] flds;
            for (Field fld : flds = ((Class)classes.get(i)).getDeclaredFields()) {
                int argGrpIdx = CommandUtils.argumentGroupIdx(grpNames, fld.getName());
                if (argGrpIdx >= 0) {
                    if (grpFlds.get(argGrpIdx) == null) {
                        grpFlds.set(argGrpIdx, new ArrayList());
                    }
                    ((List)grpFlds.get(argGrpIdx)).add(fld);
                    continue;
                }
                if (fld.isAnnotationPresent(Positional.class)) {
                    positionalParams.add(fld);
                    continue;
                }
                if (!fld.isAnnotationPresent(Argument.class)) continue;
                namedParams.add(fld);
            }
        }
        positionalParams.forEach(positionalParamVisitor);
        namedParams.forEach(namedParamVisitor);
        for (i = 0; i < grpFlds.size(); ++i) {
            argumentGroupVisitor.accept(argGprs.get(i), (List)grpFlds.get(i));
        }
    }

    private static List<ArgumentGroup> argumentGroups(Class<?> cls) {
        ArgumentGroup singleGrp = cls.getAnnotation(ArgumentGroup.class);
        if (singleGrp != null) {
            assert (cls.getAnnotation(ArgumentGroupsHolder.class) == null);
            return Collections.singletonList(singleGrp);
        }
        ArgumentGroupsHolder grps = cls.getAnnotation(ArgumentGroupsHolder.class);
        return grps == null ? Collections.emptyList() : Arrays.asList(grps.value());
    }

    public static List<Set<String>> argumentGroupsValues(Class<?> cls) {
        return CommandUtils.argumentGroupsValues(CommandUtils.argumentGroups(cls));
    }

    public static List<Set<String>> argumentGroupsValues(List<ArgumentGroup> argGrps) {
        List<Set<String>> res = argGrps.stream().map(grp -> new HashSet<String>(Arrays.asList(grp.value()))).collect(Collectors.toList());
        assert (F.flatCollections(res).stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().noneMatch(e -> (Long)e.getValue() > 1L)) : "Argument groups " + argGrps + " have not unique arguments";
        return res;
    }

    public static int argumentGroupIdx(List<Set<String>> argGrpValues, String name) {
        for (int i = 0; i < argGrpValues.size(); ++i) {
            if (!argGrpValues.get(i).contains(name)) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasDescribedParameters(Command<?, ?> cmd) {
        AtomicBoolean res = new AtomicBoolean();
        CommandUtils.visitCommandParams(cmd.argClass(), fld -> res.compareAndSet(false, CommandUtils.hasDescription(fld)), fld -> res.compareAndSet(false, CommandUtils.hasDescription(fld)), (argGrp, flds) -> flds.forEach(fld -> res.compareAndSet(false, CommandUtils.hasDescription(fld))));
        return res.get();
    }

    public static boolean hasDescription(Field fld) {
        return !fld.getAnnotation(Argument.class).description().isEmpty() || fld.isAnnotationPresent(EnumDescription.class);
    }

    @Nullable
    public static Collection<GridClientNode> coordinatorOrNull(Collection<GridClientNode> nodes) {
        return nodes.stream().filter(n -> !n.isClient()).min(Comparator.comparingLong(GridClientNode::order)).map(Collections::singleton).orElse(null);
    }

    @Nullable
    public static Collection<GridClientNode> nodeOrNull(@Nullable UUID nodeId, Collection<GridClientNode> nodes) {
        return nodeId == null ? null : CommandUtils.node(nodeId, nodes);
    }

    public static Collection<GridClientNode> nodeOrAll(@Nullable UUID nodeId, Collection<GridClientNode> nodes) {
        return nodeId == null ? nodes : CommandUtils.node(nodeId, nodes);
    }

    public static Collection<GridClientNode> nodes(UUID[] nodeIds, Collection<GridClientNode> nodes) {
        ArrayList<GridClientNode> res = new ArrayList<GridClientNode>();
        for (UUID nodeId : nodeIds) {
            res.addAll(CommandUtils.node(nodeId, nodes));
        }
        return res;
    }

    public static List<GridClientNode> node(UUID nodeId, Collection<GridClientNode> nodes) {
        for (GridClientNode node : nodes) {
            if (!node.nodeId().equals(nodeId)) continue;
            return Collections.singletonList(node);
        }
        throw new IllegalArgumentException("Node with id=" + nodeId + " not found.");
    }

    public static Collection<GridClientNode> servers(Collection<GridClientNode> nodes) {
        return nodes.stream().filter(e -> !e.isClient()).collect(Collectors.toList());
    }

    public static boolean executable(Command<?, ?> cmd) {
        return cmd instanceof LocalCommand || cmd instanceof ComputeCommand || cmd instanceof HelpCommand || cmd instanceof BeforeNodeStartCommand;
    }

    public static Collection<GridClientNode> nodes(@Nullable GridClient cli, @Nullable IgniteClient client, @Nullable Ignite ignite) throws GridClientException {
        if (cli != null) {
            return cli.compute().nodes();
        }
        if (client != null) {
            return F.viewReadOnly(client.cluster().nodes(), CommandUtils::clusterToClientNode, new IgnitePredicate[0]);
        }
        return F.viewReadOnly(ignite.cluster().nodes(), CommandUtils::clusterToClientNode, new IgnitePredicate[0]);
    }

    public static String join(String delimeter, Object ... params) {
        return CommandUtils.join(new SB(), "", delimeter, params).toString();
    }

    public static SB join(SB sb, String sbDelimeter, String delimeter, Object ... params) {
        if (!F.isEmpty(params)) {
            sb.a(sbDelimeter);
            for (Object par : params) {
                sb.a(par).a(delimeter);
            }
            sb.setLength(sb.length() - delimeter.length());
        }
        return sb;
    }

    public static boolean printErrors(Map<UUID, Exception> exceptions, String infoMsg, Consumer<String> printer) {
        if (F.isEmpty(exceptions)) {
            return false;
        }
        printer.accept(infoMsg);
        exceptions.forEach((nodeId, err) -> CommandUtils.printNodeError(printer, nodeId, null, err));
        return true;
    }

    public static void printNodeError(Consumer<String> printer, UUID nodeId, @Nullable Object consistentId, Exception err) {
        printer.accept("  Node ID: " + nodeId + (String)(consistentId == null ? "" : " [consistentId='" + consistentId + "']"));
        printer.accept("  Exception message:");
        printer.accept(DOUBLE_INDENT + err.getMessage());
        printer.accept("");
    }

    public static boolean experimental(Command<?, ?> cmd) {
        return cmd.getClass().isAnnotationPresent(IgniteExperimental.class);
    }

    private static <T> T parseSingleVal(String val, Class<T> type) {
        if (CommandUtils.isBoolean(type)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(val));
        }
        if (type == String.class) {
            return (T)val;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            int radix = CommandUtils.radix(val);
            return (T)CommandUtils.wrapNumberFormatException(() -> Integer.parseInt(radix == 10 ? val : val.substring(2), radix), val, Integer.class);
        }
        if (type == Long.class || type == Long.TYPE) {
            int radix = CommandUtils.radix(val);
            return (T)CommandUtils.wrapNumberFormatException(() -> Long.parseLong(radix == 10 ? val : val.substring(2), radix), val, Long.class);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)CommandUtils.wrapNumberFormatException(() -> Float.valueOf(Float.parseFloat(val)), val, Float.class);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)CommandUtils.wrapNumberFormatException(() -> Double.parseDouble(val), val, Double.class);
        }
        if (type == UUID.class) {
            try {
                return (T)UUID.fromString(val);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("String representation of \"java.util.UUID\" is exepected. For example: 123e4567-e89b-42d3-a456-556642440000");
            }
        }
        if (type == IgniteUuid.class) {
            return (T)IgniteUuid.fromString(val);
        }
        if (type.isEnum()) {
            try {
                return Enum.valueOf(type, val.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Can't parse value '" + val + "', expected type: " + type.getName());
            }
        }
        if (type == char[].class) {
            return (T)val.toCharArray();
        }
        throw new IgniteException("Unsupported argument type: " + type.getName());
    }

    private static int radix(String val) {
        return val.startsWith("0x") ? 16 : 10;
    }

    private static Object wrapNumberFormatException(Supplier<Object> closure, String val, Class<? extends Number> expectedType) {
        try {
            return closure.get();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Can't parse number '" + val + "', expected type: " + expectedType.getName());
        }
    }

    public static <A extends IgniteDataTransferObject> A argument(Class<A> argCls, BiFunction<Field, Integer, Object> positionalParamProvider, Function<Field, Object> paramProvider) {
        try {
            ArgumentState arg = new ArgumentState(argCls);
            CommandUtils.visitCommandParams(argCls, fld -> arg.accept((Field)fld, positionalParamProvider.apply((Field)fld, arg.nextIdx())), fld -> arg.accept((Field)fld, paramProvider.apply((Field)fld)), (argGrp, flds) -> flds.forEach(fld -> {
                if (fld.isAnnotationPresent(Positional.class)) {
                    arg.accept((Field)fld, positionalParamProvider.apply((Field)fld, arg.nextIdx()));
                } else {
                    arg.accept((Field)fld, paramProvider.apply((Field)fld));
                }
            }));
            for (int grpIdx = 0; grpIdx < arg.argGrps.size(); ++grpIdx) {
                if (arg.argGrps.get(grpIdx).optional() || arg.grpFldExists[grpIdx]) continue;
                throw new IllegalArgumentException("One of " + CommandUtils.toFormattedNames(argCls, arg.grpdFlds.get(grpIdx)) + " required");
            }
            return arg.res;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IgniteException(e);
        }
    }

    public static <A, R> R execute(@Nullable GridClient cli, @Nullable IgniteClient client, @Nullable Ignite ignite, Class<? extends VisorMultiNodeTask<A, R, ?>> taskCls, A arg, Collection<GridClientNode> nodes) throws Exception {
        Collection nodesIds = nodes.stream().map(GridClientNode::nodeId).collect(Collectors.toList());
        if (cli != null) {
            GridClientCompute compute = cli.compute();
            Collection connectable = compute.nodes().stream().filter(nodes::contains).filter(GridClientNode::connectable).collect(Collectors.toList());
            if (!connectable.isEmpty()) {
                compute = compute.projection(connectable);
            }
            return ((VisorTaskResult)compute.execute(taskCls.getName(), new VisorTaskArgument<A>(nodesIds, arg, false))).result();
        }
        if (client != null) {
            try {
                return ((VisorTaskResult)client.compute(client.cluster().forNodes(client.cluster().nodes())).execute(taskCls.getName(), new VisorTaskArgument<A>(nodesIds, arg, false))).result();
            }
            catch (InterruptedException e) {
                throw new IgniteException(e);
            }
        }
        return ((VisorTaskResult)ignite.compute(ignite.cluster()).execute(taskCls, new VisorTaskArgument<A>(nodesIds, arg, false))).result();
    }

    public static GridClientNode clusterToClientNode(final ClusterNode n) {
        return new GridClientNode(){

            @Override
            public UUID nodeId() {
                return n.id();
            }

            @Override
            public Object consistentId() {
                return n.consistentId();
            }

            @Override
            public boolean connectable() {
                return true;
            }

            @Override
            public long order() {
                return n.order();
            }

            @Override
            public boolean isClient() {
                return n.isClient();
            }

            @Override
            public List<String> tcpAddresses() {
                return U.arrayList(n.addresses());
            }

            @Override
            public List<String> tcpHostNames() {
                return U.arrayList(n.hostNames());
            }

            @Override
            public int tcpPort() {
                return -1;
            }

            @Override
            public Map<String, Object> attributes() {
                return n.attributes();
            }

            @Override
            @Nullable
            public <T> T attribute(String name) {
                return n.attribute(name);
            }

            @Override
            public GridClientNodeMetrics metrics() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Map<String, GridClientCacheMode> caches() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<InetSocketAddress> availableAddresses(GridClientProtocol proto, boolean filterResolved) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class ArgumentState<A extends IgniteDataTransferObject>
    implements BiConsumer<Field, Object> {
        private final A res;
        private final List<ArgumentGroup> argGrps;
        @Nullable
        private final boolean[] grpFldExists;
        private int idx;
        private final List<Set<String>> grpdFlds;

        public ArgumentState(Class<A> argCls) throws InstantiationException, IllegalAccessException {
            this.res = (IgniteDataTransferObject)argCls.newInstance();
            this.argGrps = CommandUtils.argumentGroups(argCls);
            this.grpdFlds = CommandUtils.argumentGroupsValues(this.argGrps);
            this.grpFldExists = this.argGrps.isEmpty() ? null : new boolean[this.argGrps.size()];
        }

        private int nextIdx() {
            int idx0 = this.idx++;
            return idx0;
        }

        @Override
        public void accept(Field fld, Object val) {
            ArgumentGroup argGrp;
            int argGrpIdx = CommandUtils.argumentGroupIdx(this.grpdFlds, fld.getName());
            assert (argGrpIdx < this.argGrps.size());
            ArgumentGroup argumentGroup = argGrp = argGrpIdx < 0 ? null : this.argGrps.get(argGrpIdx);
            if (val == null) {
                if (argGrp != null || fld.getAnnotation(Argument.class).optional()) {
                    return;
                }
                String name = fld.isAnnotationPresent(Positional.class) ? CommandUtils.parameterExample(fld, false) : CommandUtils.toFormattedFieldName(fld);
                throw new IllegalArgumentException("Argument " + name + " required.");
            }
            if (Objects.equals(val, this.get(fld))) {
                return;
            }
            if (argGrp != null) {
                assert (this.grpFldExists != null);
                if (this.grpFldExists[argGrpIdx] && argGrp.onlyOneOf()) {
                    throw new IllegalArgumentException("Only one of " + CommandUtils.toFormattedNames(this.res.getClass(), this.grpdFlds.get(argGrpIdx)) + " allowed");
                }
                this.grpFldExists[argGrpIdx] = true;
            }
            this.set(fld, val);
        }

        private Object get(Field fld) {
            try {
                return this.res.getClass().getMethod(fld.getName(), new Class[0]).invoke(this.res, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IgniteException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null && e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new IgniteException(e);
            }
        }

        private void set(Field fld, Object val) {
            try {
                this.res.getClass().getMethod(fld.getName(), fld.getType()).invoke(this.res, val);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IgniteException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null && e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new IgniteException(e);
            }
        }
    }
}

