/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRawBinarylizable;
import org.jetbrains.annotations.NotNull;

public class JdbcThinPartitionAwarenessMappingGroup
implements JdbcRawBinarylizable {
    private final Set<Integer> cacheIds = new HashSet<Integer>();
    private final Map<UUID, Set<Integer>> partitionsMappings;

    private JdbcThinPartitionAwarenessMappingGroup() {
        this.partitionsMappings = new HashMap<UUID, Set<Integer>>();
    }

    public JdbcThinPartitionAwarenessMappingGroup(@NotNull Integer cacheId, Map<UUID, @NotNull Set<Integer>> partitionsMappings) {
        this.cacheIds.add(cacheId);
        this.partitionsMappings = partitionsMappings;
    }

    public boolean merge(int cacheId, Map<UUID, Set<Integer>> partitionsMappings) {
        if (this.cacheIds.contains(cacheId)) {
            return true;
        }
        if (this.partitionsMappings.equals(partitionsMappings)) {
            this.cacheIds.add(cacheId);
            return true;
        }
        return false;
    }

    public UUID[] revertMappings(int partsCnt) {
        if (this.partitionsMappings == null) {
            return null;
        }
        UUID[] reverted = new UUID[partsCnt];
        for (UUID nodeId : this.partitionsMappings.keySet()) {
            for (Integer partition : this.partitionsMappings.get(nodeId)) {
                reverted[partition.intValue()] = nodeId;
            }
        }
        return reverted;
    }

    public Set<Integer> cacheIds() {
        return Collections.unmodifiableSet(this.cacheIds);
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        writer.writeInt(this.cacheIds.size());
        Iterator<Comparable<Integer>> iterator = this.cacheIds.iterator();
        while (iterator.hasNext()) {
            int cacheId = iterator.next();
            writer.writeInt(cacheId);
        }
        writer.writeInt(this.partitionsMappings == null ? 0 : this.partitionsMappings.size());
        if (this.partitionsMappings != null) {
            for (UUID nodeId : this.partitionsMappings.keySet()) {
                writer.writeUuid(nodeId);
                Set<Integer> nodePartitions = this.partitionsMappings.get(nodeId);
                writer.writeInt(nodePartitions == null ? 0 : nodePartitions.size());
                if (nodePartitions == null) continue;
                for (int partition : nodePartitions) {
                    writer.writeInt(partition);
                }
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
    }

    public static JdbcThinPartitionAwarenessMappingGroup readGroup(BinaryReaderExImpl reader, JdbcProtocolContext binCtx) throws BinaryObjectException {
        JdbcThinPartitionAwarenessMappingGroup res = new JdbcThinPartitionAwarenessMappingGroup();
        int cacheIdsSize = reader.readInt();
        for (int i = 0; i < cacheIdsSize; ++i) {
            res.cacheIds.add(reader.readInt());
        }
        int partitionsMappingsSize = reader.readInt();
        for (int i = 0; i < partitionsMappingsSize; ++i) {
            UUID nodeId = reader.readUuid();
            int partPerNodeSize = reader.readInt();
            HashSet<Integer> partitionsPerNode = new HashSet<Integer>();
            for (int j = 0; j < partPerNodeSize; ++j) {
                partitionsPerNode.add(reader.readInt());
            }
            res.partitionsMappings.put(nodeId, partitionsPerNode);
        }
        return res;
    }
}

