/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.persistence.params;

import java.nio.file.Path;
import org.apache.ignite.migrationtools.cli.persistence.params.MigrationMode;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

public class MigrateCacheParams {
    @CommandLine.Parameters(paramLabel="cacheName")
    private String cacheName;
    @CommandLine.Parameters(paramLabel="urls", arity="1..*", defaultValue="127.0.0.1", description={"URLs to connect to the cluster"})
    private String[] addresses;
    @CommandLine.Option(names={"--mode"}, description={"Mapping error handling policy: ${COMPLETION-CANDIDATES}"}, defaultValue="ABORT")
    private MigrationMode migrationMode;
    @CommandLine.Option(names={"--rate-limiter"}, defaultValue="-1", description={"Limits the number of migrated records per second. Uses a very basic rate limiter implementation, may be prone to bursts."})
    private int rateLimiter;
    @CommandLine.Option(names={"--no-save-progress"}, description={"Disables saving a progress file at the end of the run."})
    private boolean saveProgressFileDisabled;
    @CommandLine.Option(names={"--resume-from"}, description={"Resumes the migration based on the progress file provided."})
    @Nullable
    private Path progressFileToRead;

    private MigrateCacheParams() {
    }

    public MigrateCacheParams(String cacheName, String[] addresses, MigrationMode migrationMode, int rateLimiter, boolean saveProgressFileDisabled, @Nullable Path progressFileToRead) {
        this.cacheName = cacheName;
        this.addresses = addresses;
        this.migrationMode = migrationMode;
        this.rateLimiter = rateLimiter;
        this.saveProgressFileDisabled = saveProgressFileDisabled;
        this.progressFileToRead = progressFileToRead;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String[] addresses() {
        return this.addresses;
    }

    public MigrationMode migrationMode() {
        return this.migrationMode;
    }

    public int rateLimiter() {
        return this.rateLimiter;
    }

    public boolean saveProgressFileDisabled() {
        return this.saveProgressFileDisabled;
    }

    public Path progressFileToRead() {
        return this.progressFileToRead;
    }
}

