/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.util;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.InvalidValueException;
import org.locationtech.proj4j.UnknownAuthorityCodeException;
import org.locationtech.proj4j.UnsupportedParameterException;

public class CRSCache {
    private static CRSFactory crsFactory = new CRSFactory();
    private ConcurrentHashMap<String, CoordinateReferenceSystem> crsCache;
    private ConcurrentHashMap<String, String> epsgCache;

    public CRSCache() {
        this.crsCache = new ConcurrentHashMap();
        this.epsgCache = new ConcurrentHashMap();
    }

    public CRSCache(ConcurrentHashMap<String, CoordinateReferenceSystem> crsCache, ConcurrentHashMap<String, String> epsgCache) {
        this.crsCache = crsCache;
        this.epsgCache = epsgCache;
    }

    public CoordinateReferenceSystem createFromName(String name) throws UnsupportedParameterException, InvalidValueException, UnknownAuthorityCodeException {
        CoordinateReferenceSystem res = this.crsCache.get(name);
        if (res != null) {
            return res;
        }
        return this.crsCache.computeIfAbsent(name, k -> crsFactory.createFromName(name));
    }

    public CoordinateReferenceSystem createFromParameters(String name, String paramStr) throws UnsupportedParameterException, InvalidValueException {
        String nonNullName = name == null ? "" : name;
        String key = nonNullName + paramStr;
        CoordinateReferenceSystem res = this.crsCache.get(key);
        if (res != null) {
            return res;
        }
        return this.crsCache.computeIfAbsent(key, k -> crsFactory.createFromParameters(name, paramStr));
    }

    public CoordinateReferenceSystem createFromParameters(String name, String[] params) throws UnsupportedParameterException, InvalidValueException {
        String nonNullName = name == null ? "" : name;
        String key = nonNullName + String.join((CharSequence)" ", params);
        CoordinateReferenceSystem res = this.crsCache.get(key);
        if (res != null) {
            return res;
        }
        return this.crsCache.computeIfAbsent(key, k -> crsFactory.createFromParameters(name, params));
    }

    public String readEpsgFromParameters(String paramStr) {
        String res = this.epsgCache.get(paramStr);
        if (res != null) {
            return res;
        }
        return this.epsgCache.computeIfAbsent(paramStr, k -> {
            try {
                return crsFactory.readEpsgFromParameters(paramStr);
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    public String readEpsgFromParameters(String[] params) {
        String paramStr = String.join((CharSequence)" ", params);
        String res = this.epsgCache.get(paramStr);
        if (res != null) {
            return res;
        }
        return this.epsgCache.computeIfAbsent(paramStr, k -> {
            try {
                return crsFactory.readEpsgFromParameters(params);
            }
            catch (IOException e) {
                return null;
            }
        });
    }
}

