/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.util.Objects;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.datastructure.DataStructure;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.reuse.LongListReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageHandler;
import org.apache.ignite.internal.storage.pagememory.mv.io.BlobFragmentIo;
import org.jetbrains.annotations.Nullable;

public class BlobStorage
extends DataStructure {
    public static final long NO_PAGE_ID = 0L;
    private final RecycleAndAddToReuseBag recycleAndAddToReuseBag = new RecycleAndAddToReuseBag();
    private final ReadFragment readFragment = new ReadFragment();
    private final WriteFragment writeFragment = new WriteFragment();

    public BlobStorage(ReuseList reuseList, PageMemory pageMemory, int groupId, int partitionId) {
        super("BlobStorage", groupId, null, partitionId, pageMemory, (byte)2);
        this.reuseList = reuseList;
    }

    public byte[] readBlob(long firstPageId) throws IgniteInternalCheckedException {
        ReadState readState = new ReadState();
        long pageId = firstPageId;
        while (pageId != 0L) {
            Boolean ok = (Boolean)PageHandler.readPage((PageMemory)this.pageMem, (int)this.grpId, (long)pageId, (PageHandler)this.readFragment, (Object)readState, (int)0, (Object)false);
            assert (ok.booleanValue()) : pageId;
            pageId = readState.nextPageId;
        }
        assert (readState.bytes != null);
        return readState.bytes;
    }

    public long addBlob(byte[] bytes) throws IgniteInternalCheckedException {
        return this.doStore(0L, bytes);
    }

    public void updateBlob(long firstPageId, byte[] bytes) throws IgniteInternalCheckedException {
        this.doStore(firstPageId, bytes);
    }

    private long doStore(long maybeFirstPageId, byte[] bytes) throws IgniteInternalCheckedException {
        Objects.requireNonNull(bytes, "bytes is null");
        long firstPageId = this.allocatePageIfNeeded(maybeFirstPageId);
        WriteState state = new WriteState(bytes);
        state.pageId = firstPageId;
        do {
            Boolean ok = (Boolean)PageHandler.writePage((PageMemory)this.pageMem, (int)this.grpId, (long)state.pageId, (PageHandler)this.writeFragment, null, (Object)state, (int)0, (Object)false);
            assert (ok.booleanValue()) : state.pageId;
        } while (!state.stop);
        this.freePagesStartingWith(state.firstPageToFreeId);
        return firstPageId;
    }

    private long allocatePageIfNeeded(long maybePageId) throws IgniteInternalCheckedException {
        long pageId;
        if (maybePageId == 0L) {
            pageId = this.allocatePage(null);
            this.init(pageId, BlobFragmentIo.VERSIONS.latest());
        } else {
            pageId = maybePageId;
        }
        return pageId;
    }

    private void freePagesStartingWith(long pageId) throws IgniteInternalCheckedException {
        if (pageId != 0L) {
            this.reuseList.addForRecycle(this.recycleAndCollectPagesStartingWith(pageId));
        }
    }

    private ReuseBag recycleAndCollectPagesStartingWith(long startingPageId) throws IgniteInternalCheckedException {
        LongListReuseBag reuseBag = new LongListReuseBag();
        long pageId = startingPageId;
        while (pageId != 0L) {
            Long nextPageId = (Long)PageHandler.writePage((PageMemory)this.pageMem, (int)this.grpId, (long)pageId, (PageHandler)this.recycleAndAddToReuseBag, null, (Object)reuseBag, (int)0, (Object)pageId);
            assert (nextPageId != pageId) : pageId;
            pageId = nextPageId;
        }
        return reuseBag;
    }

    private static class RecycleAndAddToReuseBag
    implements PageHandler<ReuseBag, Long> {
        private RecycleAndAddToReuseBag() {
        }

        public Long run(int groupId, long pageId, long page, long pageAddr, PageIo io, ReuseBag reuseBag, int unused) {
            BlobFragmentIo blobIo = (BlobFragmentIo)io;
            long nextPageId = blobIo.getNextPageId(pageAddr);
            long recycledPageId = BlobStorage.recyclePage((long)pageId, (long)pageAddr);
            reuseBag.addFreePage(recycledPageId);
            return nextPageId;
        }
    }

    private class ReadFragment
    implements PageHandler<ReadState, Boolean> {
        private ReadFragment() {
        }

        public Boolean run(int groupId, long pageId, long page, long pageAddr, PageIo io, ReadState state, int unused) {
            BlobFragmentIo blobIo = (BlobFragmentIo)io;
            if (state.bytes == null) {
                assert (state.isFirstPage());
                state.bytes = new byte[blobIo.getTotalLength(pageAddr)];
            }
            int capacityForBytes = blobIo.getCapacityForFragmentBytes(BlobStorage.this.pageSize(), state.isFirstPage());
            int fragmentLength = Math.min(capacityForBytes, state.bytes.length - state.bytesOffset);
            blobIo.getFragmentBytes(pageAddr, state.isFirstPage(), state.bytes, state.bytesOffset, fragmentLength);
            long nextPageId = blobIo.getNextPageId(pageAddr);
            int newBytesOffset = state.bytesOffset + fragmentLength;
            if (newBytesOffset < state.bytes.length) {
                assert (nextPageId != 0L);
                state.nextPageId = nextPageId;
            } else {
                assert (nextPageId == 0L);
                state.nextPageId = 0L;
            }
            state.bytesOffset = newBytesOffset;
            return true;
        }
    }

    private class WriteFragment
    implements PageHandler<WriteState, Boolean> {
        private WriteFragment() {
        }

        public Boolean run(int groupId, long pageId, long page, long pageAddr, PageIo io, WriteState state, int unused) throws IgniteInternalCheckedException {
            BlobFragmentIo blobIo = (BlobFragmentIo)io;
            int capacityForBytes = blobIo.getCapacityForFragmentBytes(BlobStorage.this.pageSize(), state.isFirstPage());
            int fragmentLength = Math.min(capacityForBytes, state.bytes.length - state.bytesOffset);
            if (state.isFirstPage()) {
                blobIo.setTotalLength(pageAddr, state.bytes.length);
            }
            blobIo.setFragmentBytes(pageAddr, state.isFirstPage(), state.bytes, state.bytesOffset, fragmentLength);
            int newBytesOffset = state.bytesOffset + fragmentLength;
            long maybeNextPageId = blobIo.getNextPageId(pageAddr);
            if (newBytesOffset < state.bytes.length) {
                long nextPageId = BlobStorage.this.allocatePageIfNeeded(maybeNextPageId);
                blobIo.setNextPageId(pageAddr, nextPageId);
                state.bytesOffset = newBytesOffset;
                state.pageId = nextPageId;
            } else {
                blobIo.setNextPageId(pageAddr, 0L);
                state.firstPageToFreeId = maybeNextPageId;
                state.stop = true;
            }
            return true;
        }
    }

    private static class ReadState {
        private byte @Nullable [] bytes;
        private int bytesOffset;
        private long nextPageId = 0L;

        private ReadState() {
        }

        private boolean isFirstPage() {
            return this.bytesOffset == 0;
        }
    }

    private static class WriteState {
        private final byte[] bytes;
        private int bytesOffset;
        private long pageId;
        private boolean stop;
        private long firstPageToFreeId = 0L;

        private WriteState(byte[] bytes) {
            this.bytes = bytes;
        }

        private boolean isFirstPage() {
            return this.bytesOffset == 0;
        }
    }
}

