/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.configuration.ConfigurationModule;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.configuration.annotation.ConfigurationType;
import org.apache.ignite.internal.storage.configurations.StorageExtensionChange;
import org.apache.ignite.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileChange;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileConfigurationSchema;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineExtensionConfigurationSchema;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileConfigurationSchema;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineExtensionConfigurationSchema;

@AutoService(value={ConfigurationModule.class})
public class PageMemoryStorageEngineLocalConfigurationModule
implements ConfigurationModule {
    public static final String DEFAULT_PROFILE_NAME = "default";

    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return List.of(VolatilePageMemoryProfileConfigurationSchema.class, PersistentPageMemoryProfileConfigurationSchema.class);
    }

    public Collection<Class<?>> schemaExtensions() {
        return List.of(PersistentPageMemoryStorageEngineExtensionConfigurationSchema.class, VolatilePageMemoryStorageEngineExtensionConfigurationSchema.class);
    }

    public void patchConfigurationWithDynamicDefaults(SuperRootChange rootChange) {
        StorageExtensionChange storageExtensionChange = (StorageExtensionChange)rootChange.changeRoot(StorageExtensionConfiguration.KEY);
        NamedListChange profiles = storageExtensionChange.changeStorage().changeProfiles();
        if (profiles.get(DEFAULT_PROFILE_NAME) == null) {
            profiles.create(DEFAULT_PROFILE_NAME, profileChange -> profileChange.convert(PersistentPageMemoryProfileChange.class));
        }
    }
}

