/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.table.MutableTupleBinaryTupleAdapter;
import org.apache.ignite.sql.ColumnMetadata;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.Tuple;

class ClientSqlRow
extends MutableTupleBinaryTupleAdapter
implements SqlRow {
    private final ResultSetMetadata metadata;

    ClientSqlRow(BinaryTupleReader row, ResultSetMetadata meta) {
        super(row, meta.columns().size(), null);
        assert (row != null);
        assert (meta != null);
        this.metadata = meta;
    }

    public int columnCount() {
        return this.metadata.columns().size();
    }

    public String columnName(int columnIndex) {
        return ((ColumnMetadata)this.metadata.columns().get(columnIndex)).name();
    }

    public int columnIndex(String columnName) {
        return this.metadata.indexOf(columnName);
    }

    public Tuple set(String columnName, Object value) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    protected String schemaColumnName(int binaryTupleIndex) {
        return this.columnName(binaryTupleIndex);
    }

    protected int binaryTupleIndex(String columnName) {
        return this.columnIndex(columnName);
    }

    protected ColumnType schemaColumnType(int binaryTupleIndex) {
        return ((ColumnMetadata)this.metadata.columns().get(binaryTupleIndex)).type();
    }

    protected int schemaDecimalScale(int binaryTupleIndex) {
        return ((ColumnMetadata)this.metadata.columns().get(binaryTupleIndex)).scale();
    }

    public ResultSetMetadata metadata() {
        return this.metadata;
    }
}

