/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleFormatException;
import org.apache.ignite.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite.internal.lang.InternalTuple;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.schema.BinaryTupleSchema;
import org.apache.ignite.internal.schema.ColumnsExtractor;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class BinaryRowConverter
implements ColumnsExtractor {
    private final BinaryTupleSchema srcSchema;
    private final BinaryTupleSchema dstSchema;

    public BinaryRowConverter(BinaryTupleSchema srcSchema, BinaryTupleSchema dstSchema) {
        this.srcSchema = srcSchema;
        this.dstSchema = dstSchema;
    }

    @Override
    public BinaryTuple extractColumns(BinaryRow row) {
        assert (this.srcSchema.convertible());
        ByteBuffer tupleBuffer = row.tupleSlice();
        BinaryTupleParser parser = new BinaryTupleParser(this.srcSchema.elementCount(), tupleBuffer);
        var stats = new BinaryTupleParser.Sink(){
            int estimatedValueSize = 0;

            public void nextElement(int index, int begin, int end) {
                this.estimatedValueSize += end - begin;
            }
        };
        for (int elementIndex = 0; elementIndex < this.dstSchema.elementCount(); ++elementIndex) {
            int columnIndex = this.dstSchema.columnIndex(elementIndex);
            parser.fetch(columnIndex, stats);
        }
        BinaryTupleBuilder builder = new BinaryTupleBuilder(this.dstSchema.elementCount(), stats.estimatedValueSize);
        BinaryTupleParser.Sink builderSink = (index, begin, end) -> {
            if (begin == end) {
                builder.appendNull();
            } else {
                builder.appendElementBytes(tupleBuffer, begin, end - begin);
            }
        };
        for (int elementIndex = 0; elementIndex < this.dstSchema.elementCount(); ++elementIndex) {
            int columnIndex = this.dstSchema.columnIndex(elementIndex);
            parser.fetch(columnIndex, builderSink);
        }
        return new BinaryTuple(this.dstSchema.elementCount(), builder.build());
    }

    public static BinaryTupleBuilder appendValue(BinaryTupleBuilder builder, BinaryTupleSchema.Element element, @Nullable Object value) {
        if (value == null) {
            if (!element.nullable()) {
                throw new BinaryTupleFormatException("NULL value for non-nullable column in binary tuple builder.");
            }
            return builder.appendNull();
        }
        switch (element.typeSpec()) {
            case BOOLEAN: {
                return builder.appendBoolean(((Boolean)value).booleanValue());
            }
            case INT8: {
                return builder.appendByte(((Byte)value).byteValue());
            }
            case INT16: {
                return builder.appendShort(((Short)value).shortValue());
            }
            case INT32: {
                return builder.appendInt(((Integer)value).intValue());
            }
            case INT64: {
                return builder.appendLong(((Long)value).longValue());
            }
            case FLOAT: {
                return builder.appendFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return builder.appendDouble(((Double)value).doubleValue());
            }
            case DECIMAL: {
                return builder.appendDecimalNotNull((BigDecimal)value, element.decimalScale());
            }
            case UUID: {
                return builder.appendUuidNotNull((UUID)value);
            }
            case BYTE_ARRAY: {
                return builder.appendBytesNotNull((byte[])value);
            }
            case STRING: {
                return builder.appendStringNotNull((String)value);
            }
            case DATE: {
                return builder.appendDateNotNull((LocalDate)value);
            }
            case TIME: {
                return builder.appendTimeNotNull((LocalTime)value);
            }
            case DATETIME: {
                return builder.appendDateTimeNotNull((LocalDateTime)value);
            }
            case TIMESTAMP: {
                return builder.appendTimestampNotNull((Instant)value);
            }
        }
        throw new InvalidTypeException("Unexpected type value: " + String.valueOf(element.typeSpec()));
    }

    public static void copyColumnValue(InternalTuple delegate, BinaryTupleBuilder builder, BinaryTupleSchema.Element element, int col) {
        if (delegate.hasNullValue(col)) {
            builder.appendNull();
            return;
        }
        switch (element.typeSpec()) {
            case BOOLEAN: {
                builder.appendBoolean(delegate.booleanValue(col));
                return;
            }
            case INT8: {
                builder.appendByte(delegate.byteValue(col));
                return;
            }
            case INT16: {
                builder.appendShort(delegate.shortValue(col));
                return;
            }
            case INT32: {
                builder.appendInt(delegate.intValue(col));
                return;
            }
            case INT64: {
                builder.appendLong(delegate.longValue(col));
                return;
            }
            case FLOAT: {
                builder.appendFloat(delegate.floatValue(col));
                return;
            }
            case DOUBLE: {
                builder.appendDouble(delegate.doubleValue(col));
                return;
            }
            case DECIMAL: {
                builder.appendDecimalNotNull(delegate.decimalValue(col, element.decimalScale()), element.decimalScale());
                return;
            }
            case UUID: {
                builder.appendUuidNotNull(delegate.uuidValue(col));
                return;
            }
            case BYTE_ARRAY: {
                builder.appendBytesNotNull(delegate.bytesValue(col));
                return;
            }
            case STRING: {
                builder.appendStringNotNull(delegate.stringValue(col));
                return;
            }
            case DATE: {
                builder.appendDateNotNull(delegate.dateValue(col));
                return;
            }
            case TIME: {
                builder.appendTimeNotNull(delegate.timeValue(col));
                return;
            }
            case DATETIME: {
                builder.appendDateTimeNotNull(delegate.dateTimeValue(col));
                return;
            }
            case TIMESTAMP: {
                builder.appendTimestampNotNull(delegate.timestampValue(col));
                return;
            }
        }
        throw new InvalidTypeException("Unexpected type value: " + String.valueOf(element.typeSpec()));
    }

    @TestOnly
    public BinaryTupleSchema dstSchema() {
        return this.dstSchema;
    }

    public static BinaryRowConverter keyExtractor(SchemaDescriptor schema) {
        BinaryTupleSchema rowSchema = BinaryTupleSchema.createRowSchema(schema);
        BinaryTupleSchema keySchema = BinaryTupleSchema.createDestinationKeySchema(schema);
        return new BinaryRowConverter(rowSchema, keySchema);
    }

    public static BinaryRowConverter columnsExtractor(SchemaDescriptor schema, int ... columns) {
        BinaryTupleSchema rowSchema = BinaryTupleSchema.createRowSchema(schema);
        BinaryTupleSchema trimmedSchema = BinaryTupleSchema.createSchema(schema, columns);
        return new BinaryRowConverter(rowSchema, trimmedSchema);
    }
}

