/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaAware;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRowTupleAdapter
implements Tuple,
SchemaAware {
    @Nullable
    protected transient Row row;

    public AbstractRowTupleAdapter(Row row) {
        this.row = row;
    }

    public SchemaDescriptor schema() {
        return this.row.schema();
    }

    public int columnCount() {
        return this.row.elementCount();
    }

    public String columnName(int columnIndex) {
        return IgniteNameUtils.quoteIfNeeded((String)this.rowColumnByIndex(columnIndex).name());
    }

    public int columnIndex(String columnName) {
        Objects.requireNonNull(columnName);
        Column col = this.row.schema().column(IgniteNameUtils.parseIdentifier((String)columnName));
        if (col == null) {
            return -1;
        }
        return this.correctIndex(col);
    }

    public <T> T valueOrDefault(String columnName, T defaultValue) {
        Objects.requireNonNull(columnName);
        Column col = this.row.schema().column(IgniteNameUtils.parseIdentifier((String)columnName));
        return (T)(col == null ? defaultValue : this.row.value(this.correctIndex(col)));
    }

    public <T> T value(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return (T)this.row.value(this.correctIndex(col));
    }

    public <T> T value(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return (T)this.row.value(this.correctIndex(col));
    }

    public boolean booleanValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.booleanValue(this.correctIndex(col));
    }

    public boolean booleanValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.booleanValue(this.correctIndex(col));
    }

    public byte byteValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.byteValue(col.positionInRow());
    }

    public byte byteValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.byteValue(col.positionInRow());
    }

    public short shortValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.shortValue(col.positionInRow());
    }

    public short shortValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.shortValue(col.positionInRow());
    }

    public int intValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.intValue(col.positionInRow());
    }

    public int intValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.intValue(col.positionInRow());
    }

    public long longValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.longValue(this.correctIndex(col));
    }

    public long longValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.longValue(this.correctIndex(col));
    }

    public float floatValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.floatValue(this.correctIndex(col));
    }

    public float floatValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.floatValue(this.correctIndex(col));
    }

    public double doubleValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.doubleValue(this.correctIndex(col));
    }

    public double doubleValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.doubleValue(this.correctIndex(col));
    }

    public BigDecimal decimalValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.decimalValue(this.correctIndex(col));
    }

    public BigDecimal decimalValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.decimalValue(this.correctIndex(col));
    }

    public String stringValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.stringValue(this.correctIndex(col));
    }

    public String stringValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.stringValue(this.correctIndex(col));
    }

    public byte[] bytesValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.bytesValue(this.correctIndex(col));
    }

    public byte[] bytesValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.bytesValue(this.correctIndex(col));
    }

    public UUID uuidValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.uuidValue(this.correctIndex(col));
    }

    public UUID uuidValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.uuidValue(this.correctIndex(col));
    }

    public LocalDate dateValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.dateValue(this.correctIndex(col));
    }

    public LocalDate dateValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.dateValue(this.correctIndex(col));
    }

    public LocalTime timeValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.timeValue(this.correctIndex(col));
    }

    public LocalTime timeValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.timeValue(this.correctIndex(col));
    }

    public LocalDateTime datetimeValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.dateTimeValue(this.correctIndex(col));
    }

    public LocalDateTime datetimeValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.dateTimeValue(this.correctIndex(col));
    }

    public Instant timestampValue(String columnName) {
        Column col = this.rowColumnByName(columnName);
        return this.row.timestampValue(this.correctIndex(col));
    }

    public Instant timestampValue(int columnIndex) {
        Column col = this.rowColumnByIndex(columnIndex);
        return this.row.timestampValue(this.correctIndex(col));
    }

    public int hashCode() {
        return Tuple.hashCode((Tuple)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Tuple) {
            return Tuple.equals((Tuple)this, (Tuple)((Tuple)obj));
        }
        return false;
    }

    protected Column rowColumnByName(String columnName) {
        Objects.requireNonNull(columnName);
        Column col = this.row.schema().column(IgniteNameUtils.parseIdentifier((String)columnName));
        if (col == null) {
            throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Column doesn't exist [name={}]", (Object[])new Object[]{columnName}));
        }
        return col;
    }

    protected Column rowColumnByIndex(int columnIndex) {
        List columns = this.row.keyOnly() ? this.row.schema().keyColumns() : this.row.schema().columns();
        Objects.checkIndex(columnIndex, columns.size());
        return (Column)columns.get(columnIndex);
    }

    private int correctIndex(Column col) {
        return this.row.keyOnly() ? col.positionInKey() : col.positionInRow();
    }
}

