/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.placementdriver.negotiation;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.partitiondistribution.Assignment;
import org.apache.ignite.internal.placementdriver.leases.Lease;
import org.apache.ignite.internal.placementdriver.message.LeaseGrantedMessageResponse;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class LeaseAgreement {
    private static final IgniteLogger LOG = Loggers.forClass(LeaseAgreement.class);
    static final LeaseAgreement UNDEFINED_AGREEMENT = new LeaseAgreement(null, CompletableFutures.nullCompletedFuture(), false);
    private final Lease lease;
    private final boolean forced;
    private final CompletableFuture<LeaseGrantedMessageResponse> responseFut;

    public LeaseAgreement(Lease lease, boolean forced) {
        this(lease, new CompletableFuture<LeaseGrantedMessageResponse>(), forced);
    }

    private LeaseAgreement(Lease lease, CompletableFuture<LeaseGrantedMessageResponse> remoteNodeResponseFuture, boolean forced) {
        this.lease = lease;
        this.responseFut = Objects.requireNonNull(remoteNodeResponseFuture);
        this.forced = forced;
    }

    public Lease getLease() {
        return this.lease;
    }

    public ReplicationGroupId groupId() {
        return this.lease.replicationGroupId();
    }

    public boolean forced() {
        return this.forced;
    }

    public boolean isAccepted() {
        if (!this.ready()) {
            return false;
        }
        LeaseGrantedMessageResponse resp = this.responseFut.join();
        if (resp != null) {
            return resp.accepted();
        }
        return false;
    }

    public boolean isDeclined() {
        return this.ready() && !this.isAccepted();
    }

    @Nullable
    public String getRedirectTo() {
        assert (this.ready()) : "The method should be invoked only after the agreement is ready";
        LeaseGrantedMessageResponse resp = this.responseFut.join();
        return resp != null ? resp.redirectProposal() : null;
    }

    public boolean ready() {
        return this.responseFut.isDone();
    }

    public boolean isCancelled() {
        return this.responseFut.isDone() && !this.responseFut.isCompletedExceptionally() && this.responseFut.join() == null;
    }

    public void checkValid(ReplicationGroupId groupId, @Nullable LogicalTopologySnapshot currentTopologySnapshot, Set<Assignment> assignments) {
        Set nodeIds;
        if (this.ready()) {
            return;
        }
        if (IgniteUtils.findAny(assignments, a -> a.consistentId().equals(this.lease.getLeaseholder())).isEmpty()) {
            LOG.info("Lease was not negotiated because the node is not included into the group assignments anymore [node={}, group={}, assignments={}].", new Object[]{this.lease.getLeaseholder(), this.lease, assignments});
            this.responseFut.complete(null);
        } else if (currentTopologySnapshot != null && !(nodeIds = currentTopologySnapshot.nodes().stream().map(ClusterNodeImpl::id).collect(Collectors.toSet())).contains(this.lease.getLeaseholderId())) {
            LOG.info("Lease was not negotiated because the node has left the logical topology [node={}, nodeId={}, group={}]", new Object[]{this.lease.getLeaseholder(), this.lease.getLeaseholderId(), groupId});
            this.responseFut.complete(null);
        }
    }

    void onResponse(LeaseGrantedMessageResponse response) {
        this.responseFut.complete(response);
    }

    void cancel() {
        this.responseFut.complete(null);
    }
}

