/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util.format;

import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.sql.engine.util.format.DateTimeFormatElement;
import org.apache.ignite.internal.sql.engine.util.format.DateTimeTemplateField;
import org.jetbrains.annotations.Nullable;

final class Formatter {
    private final StringBuilder out = new StringBuilder();
    private final List<DateTimeFormatElement> elements;

    Formatter(List<DateTimeFormatElement> elements) {
        this.elements = elements;
    }

    String format(TemporalAccessor value, ZoneOffset zoneOffset) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(zoneOffset, "zoneOffset");
        this.out.setLength(0);
        this.appendElements(value, zoneOffset);
        return this.out.toString();
    }

    private void appendElements(TemporalAccessor value, @Nullable ZoneOffset zoneOffset) {
        block4: for (DateTimeFormatElement element : this.elements) {
            switch (element.kind) {
                case DELIMITER: {
                    this.out.append(element.delimiter);
                    continue block4;
                }
                case FIELD: {
                    assert (element.template != null);
                    this.appendField(value, element.template, zoneOffset);
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected element kind: " + String.valueOf((Object)element.kind));
        }
    }

    private void appendField(TemporalAccessor value, DateTimeTemplateField field, @Nullable ZoneOffset zoneOffset) {
        switch (field) {
            case YYYY: {
                this.appendField(value, ChronoField.YEAR, 4);
                break;
            }
            case YYY: {
                this.appendField(value, ChronoField.YEAR, 3);
                break;
            }
            case YY: {
                this.appendField(value, ChronoField.YEAR, 2);
                break;
            }
            case Y: {
                this.appendField(value, ChronoField.YEAR, 1);
                break;
            }
            case RRRR: {
                this.appendField(value, ChronoField.YEAR, 4);
                break;
            }
            case RR: {
                this.appendField(value, ChronoField.YEAR, 2);
                break;
            }
            case MM: {
                this.appendField(value, ChronoField.MONTH_OF_YEAR, 2);
                break;
            }
            case DD: {
                this.appendField(value, ChronoField.DAY_OF_MONTH, 2);
                break;
            }
            case DDD: {
                this.appendField(value, ChronoField.DAY_OF_YEAR, 3);
                break;
            }
            case HH: 
            case HH12: {
                int hours = value.get(ChronoField.HOUR_OF_DAY);
                if (hours >= 13) {
                    hours -= 12;
                } else if (hours == 0) {
                    hours = 12;
                } else if (hours != 12) {
                    hours %= 12;
                }
                this.appendField(hours, 2);
                break;
            }
            case HH24: {
                this.appendField(value, ChronoField.HOUR_OF_DAY, 2);
                break;
            }
            case MI: {
                this.appendField(value, ChronoField.MINUTE_OF_HOUR, 2);
                break;
            }
            case SS: {
                this.appendField(value, ChronoField.SECOND_OF_MINUTE, 2);
                break;
            }
            case SSSSS: {
                this.appendField(value, ChronoField.SECOND_OF_DAY, 5);
                break;
            }
            case FF1: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND) / 100000000, 1);
                break;
            }
            case FF2: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND) / 10000000, 2);
                break;
            }
            case FF3: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND) / 1000000, 3);
                break;
            }
            case FF4: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND) / 100000, 4);
                break;
            }
            case FF5: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND) / 10000, 5);
                break;
            }
            case FF6: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND) / 1000, 6);
                break;
            }
            case FF7: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND) / 100, 7);
                break;
            }
            case FF8: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND) / 10, 8);
                break;
            }
            case FF9: {
                this.appendField(value.get(ChronoField.NANO_OF_SECOND), 9);
                break;
            }
            case PM: 
            case AM: {
                int hours = value.get(ChronoField.HOUR_OF_DAY);
                if (hours <= 11) {
                    this.out.append("A.M.");
                    break;
                }
                this.out.append("P.M.");
                break;
            }
            case TZH: {
                assert (zoneOffset != null);
                if (zoneOffset.getTotalSeconds() < 0) {
                    this.out.append('-');
                } else {
                    this.out.append('+');
                }
                int tzSeconds = Math.abs(zoneOffset.get(ChronoField.OFFSET_SECONDS));
                int tzHours = tzSeconds / 3600;
                this.appendField(tzHours, 2);
                break;
            }
            case TZM: {
                assert (zoneOffset != null);
                int tzSeconds = Math.abs(zoneOffset.get(ChronoField.OFFSET_SECONDS));
                int tzHours = tzSeconds / 3600;
                int tzMinutes = (tzSeconds - tzHours * 60 * 60) / 60;
                this.appendField(tzMinutes, 2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected field: " + String.valueOf((Object)field));
            }
        }
    }

    private void appendField(TemporalAccessor data, ChronoField field, int maxDigits) {
        long scaled = data.get(field);
        this.appendField(scaled, maxDigits);
    }

    private void appendField(long val, int maxDigits) {
        assert (val >= 0L);
        for (int i = 0; i < maxDigits; ++i) {
            this.out.append('0');
        }
        int pos = maxDigits - 1;
        int start = this.out.length() - maxDigits;
        long scaled = val;
        do {
            int digit = (int)(scaled % 10L);
            char c = (char)(48 + digit);
            this.out.setCharAt(start + pos, c);
        } while ((scaled /= 10L) != 0L && --pos >= 0);
    }
}

