/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;

public class IgniteTrimExchange
extends Exchange
implements SourceAwareIgniteRel {
    private static final String REL_TYPE_NAME = "TrimExchange";
    private final long sourceId;

    public IgniteTrimExchange(RelOptCluster cluster, RelTraitSet traits, RelNode input, RelDistribution distribution) {
        this(-1L, cluster, traits, input, distribution);
    }

    public IgniteTrimExchange(long sourceId, RelOptCluster cluster, RelTraitSet traits, RelNode input, RelDistribution distribution) {
        super(cluster, traits, input, distribution);
        assert (distribution.getType() == RelDistribution.Type.HASH_DISTRIBUTED);
        this.sourceId = sourceId;
    }

    public IgniteTrimExchange(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE, input.getDistribution()}));
        Object srcIdObj = input.get("sourceId");
        this.sourceId = srcIdObj != null ? ((Number)srcIdObj).longValue() : -1L;
    }

    @Override
    public long sourceId() {
        return this.sourceId;
    }

    @Override
    public IgniteDistribution distribution() {
        return (IgniteDistribution)this.distribution;
    }

    public boolean isEnforcer() {
        return true;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("sourceId", (Object)this.sourceId, this.sourceId != -1L);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this.getInput());
        return planner.getCostFactory().makeCost(rowCount, rowCount * 4.0, 0.0);
    }

    public Exchange copy(RelTraitSet traits, RelNode input, RelDistribution distribution) {
        return new IgniteTrimExchange(this.getCluster(), traits, input, distribution);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IgniteRel clone(long sourceId) {
        return new IgniteTrimExchange(sourceId, this.getCluster(), this.getTraitSet(), this.getInput(), this.getDistribution());
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteTrimExchange(this.sourceId, cluster, this.getTraitSet(), (RelNode)IgniteTrimExchange.sole(inputs), this.getDistribution());
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return writer.addDistribution(this.distribution(), this.getRowType());
    }
}

