/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.prepare.ddl;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.prepare.ddl.NodeFilterValidator;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;

public class ClusterWideNodeFilterValidator
implements NodeFilterValidator {
    private final LogicalTopologyService logicalTopologyService;

    public ClusterWideNodeFilterValidator(LogicalTopologyService logicalTopologyService) {
        this.logicalTopologyService = logicalTopologyService;
    }

    @Override
    public CompletableFuture<Void> validate(@Nullable String nodeFilter) {
        if (nodeFilter == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        Set<NodeWithAttributes> filtered = ClusterWideNodeFilterValidator.filteredTopologyNodes(this.logicalTopologyService.localLogicalTopology(), nodeFilter);
        if (!filtered.isEmpty()) {
            return CompletableFutures.nullCompletedFuture();
        }
        return this.logicalTopologyService.logicalTopologyOnLeader().handle((snapshot, e) -> {
            if (e == null) {
                if (ClusterWideNodeFilterValidator.filteredTopologyNodes(snapshot, nodeFilter).isEmpty()) {
                    throw new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, IgniteStringFormatter.format((String)"Node filter does not match any node in the cluster [filter='{}'].", (Object[])new Object[]{nodeFilter}));
                }
                return null;
            }
            throw new SqlException(ErrorGroups.Common.INTERNAL_ERR, "Distributed validation of the node filter for distribution zone failed [filter='{}'].", e);
        });
    }

    private static Set<NodeWithAttributes> filteredTopologyNodes(LogicalTopologySnapshot snapshot, String nodeFilter) {
        Set nodes = snapshot.nodes().stream().map(n -> new NodeWithAttributes(n.name(), n.id(), n.userAttributes(), n.storageProfiles())).collect(Collectors.toSet());
        return nodes.stream().filter(n -> DistributionZonesUtil.filterNodeAttributes((Map)n.userAttributes(), (String)nodeFilter)).collect(Collectors.toSet());
    }
}

