/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster;

import org.apache.ignite.internal.sql.engine.exec.mapping.ColocationMappingException;
import org.apache.ignite.internal.sql.engine.exec.mapping.ExecutionTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.AbstractTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.AllOfTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.PartitionedTarget;
import org.apache.ignite.internal.sql.engine.exec.mapping.smallcluster.SomeOfTarget;
import org.apache.ignite.internal.util.IgniteUtils;

class OneOfTarget
extends AbstractTarget {
    OneOfTarget(long nodes) {
        super(nodes);
    }

    @Override
    public ExecutionTarget finalise() {
        if (IgniteUtils.isPow2((long)this.nodes)) {
            return this;
        }
        return new OneOfTarget(OneOfTarget.pickOne(this.nodes));
    }

    @Override
    public ExecutionTarget colocateWith(ExecutionTarget other) throws ColocationMappingException {
        assert (other instanceof AbstractTarget) : other == null ? "<null>" : other.getClass().getCanonicalName();
        return ((AbstractTarget)other).colocate(this);
    }

    @Override
    public ExecutionTarget trimTo(ExecutionTarget other) {
        assert (other instanceof AbstractTarget) : other == null ? "<null>" : other.getClass().getCanonicalName();
        long otherNodes = ((AbstractTarget)other).nodes;
        long newNodes = this.nodes & otherNodes;
        if (newNodes == this.nodes || newNodes == 0L) {
            return this;
        }
        return new OneOfTarget(newNodes);
    }

    @Override
    public ExecutionTarget colocate(AllOfTarget other) throws ColocationMappingException {
        return OneOfTarget.colocate(other, this);
    }

    @Override
    public ExecutionTarget colocate(OneOfTarget other) throws ColocationMappingException {
        return OneOfTarget.colocate(this, other);
    }

    @Override
    public ExecutionTarget colocate(PartitionedTarget other) throws ColocationMappingException {
        return OneOfTarget.colocate(this, other);
    }

    @Override
    public ExecutionTarget colocate(SomeOfTarget other) throws ColocationMappingException {
        return OneOfTarget.colocate(this, other);
    }
}

