/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine;

import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.sql.engine.InternalSqlRow;

public class InternalSqlRowSingleLong
implements InternalSqlRow {
    private final long val;
    private BinaryTuple row;

    public InternalSqlRowSingleLong(long val) {
        this.val = val;
    }

    public Object get(int idx) {
        assert (idx == 0);
        return this.val;
    }

    public int fieldCount() {
        return 1;
    }

    public BinaryTuple asBinaryTuple() {
        if (this.row == null) {
            this.row = new BinaryTuple(1, new BinaryTupleBuilder(1, InternalSqlRowSingleLong.estimateSize(this.val)).appendLong(this.val).build());
        }
        return this.row;
    }

    private static int estimateSize(long value) {
        if (value <= 127L && value >= -128L) {
            return 1;
        }
        if (value <= 32767L && value >= -32768L) {
            return 2;
        }
        if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
            return 4;
        }
        return 8;
    }
}

