/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.rebalance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.events.AlterZoneEventParameters;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.components.NodeProperties;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.rebalance.DistributionZoneRebalanceEngineV2;
import org.apache.ignite.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite.internal.distributionzones.utils.CatalogAlterZoneEventListener;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteSystemProperties;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.TestOnly;

public class DistributionZoneRebalanceEngine {
    private static final IgniteLogger LOG = Loggers.forClass(DistributionZoneRebalanceEngine.class);
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final IgniteSpinBusyLock busyLock;
    private final MetaStorageManager metaStorageManager;
    private final DistributionZoneManager distributionZoneManager;
    private final WatchListener dataNodesListener;
    private final CatalogService catalogService;
    private final NodeProperties nodeProperties;
    private final DistributionZoneRebalanceEngineV2 distributionZoneRebalanceEngineV2;
    @TestOnly
    public static final String SKIP_REBALANCE_TRIGGERS_RECOVERY = "IGNITE_SKIP_REBALANCE_TRIGGERS_RECOVERY";

    public DistributionZoneRebalanceEngine(IgniteSpinBusyLock busyLock, MetaStorageManager metaStorageManager, DistributionZoneManager distributionZoneManager, CatalogManager catalogService, NodeProperties nodeProperties) {
        this.busyLock = busyLock;
        this.metaStorageManager = metaStorageManager;
        this.distributionZoneManager = distributionZoneManager;
        this.catalogService = catalogService;
        this.nodeProperties = nodeProperties;
        this.dataNodesListener = this.createDistributionZonesDataNodesListener();
        this.distributionZoneRebalanceEngineV2 = new DistributionZoneRebalanceEngineV2(busyLock, metaStorageManager, distributionZoneManager, catalogService);
    }

    public CompletableFuture<Void> startAsync(int catalogVersion) {
        return IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            this.catalogService.listen((Event)CatalogEvent.ZONE_ALTER, (EventListener)new CatalogAlterZoneEventListener(this.catalogService){

                @Override
                protected CompletableFuture<Void> onReplicasUpdate(AlterZoneEventParameters parameters, int oldReplicas) {
                    return DistributionZoneRebalanceEngine.this.onUpdateReplicas(parameters);
                }
            });
            this.metaStorageManager.registerPrefixWatch(DistributionZonesUtil.zoneDataNodesHistoryPrefix(), this.dataNodesListener);
            CompletableFuture recoveryFinishFuture = this.metaStorageManager.recoveryFinishedFuture();
            assert (recoveryFinishFuture.isDone());
            long recoveryRevision = ((Revisions)recoveryFinishFuture.join()).revision();
            if (IgniteSystemProperties.getBoolean((String)SKIP_REBALANCE_TRIGGERS_RECOVERY, (boolean)false)) {
                return CompletableFutures.nullCompletedFuture();
            }
            if (this.nodeProperties.colocationEnabled()) {
                return this.recoveryRebalanceTrigger(recoveryRevision, catalogVersion).thenCompose(v -> this.distributionZoneRebalanceEngineV2.startAsync());
            }
            return this.recoveryRebalanceTrigger(recoveryRevision, catalogVersion);
        });
    }

    private CompletableFuture<Void> recoveryRebalanceTrigger(long recoveryRevision, int catalogVersion) {
        if (recoveryRevision > 0L) {
            HybridTimestamp recoveryTimestamp = this.metaStorageManager.timestampByRevisionLocally(recoveryRevision);
            List<CompletableFuture> zonesRecoveryFutures = this.catalogService.catalog(catalogVersion).zones().stream().map(zoneDesc -> this.recalculateAssignmentsAndScheduleRebalance((CatalogZoneDescriptor)zoneDesc, recoveryRevision, recoveryTimestamp, catalogVersion)).collect(Collectors.toUnmodifiableList());
            return CompletableFuture.allOf(zonesRecoveryFutures.toArray(new CompletableFuture[0]));
        }
        return CompletableFutures.nullCompletedFuture();
    }

    public void stop() {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        if (this.nodeProperties.colocationEnabled()) {
            this.distributionZoneRebalanceEngineV2.stop();
        }
        this.metaStorageManager.unregisterWatch(this.dataNodesListener);
    }

    private WatchListener createDistributionZonesDataNodesListener() {
        return evt -> IgniteUtils.inBusyLockAsync((IgniteSpinBusyLock)this.busyLock, () -> {
            Set<NodeWithAttributes> dataNodes = DistributionZonesUtil.parseDataNodes(evt.entryEvent().newEntry().value(), evt.timestamp());
            if (dataNodes == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            int zoneId = RebalanceUtil.extractZoneId(evt.entryEvent().newEntry().key(), DistributionZonesUtil.DISTRIBUTION_ZONE_DATA_NODES_HISTORY_PREFIX_BYTES);
            int latestCatalogVersion = this.catalogService.latestCatalogVersion();
            Catalog catalog = this.catalogService.catalog(latestCatalogVersion);
            long assignmentsTimestamp = catalog.time();
            CatalogZoneDescriptor zoneDescriptor = catalog.zone(zoneId);
            if (zoneDescriptor == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            Set<String> filteredDataNodes = DistributionZonesUtil.nodeNames(DistributionZonesUtil.filterDataNodes(dataNodes, zoneDescriptor));
            if (LOG.isInfoEnabled()) {
                ArrayList<NodeWithAttributes> matchedNodes = new ArrayList<NodeWithAttributes>();
                ArrayList<NodeWithAttributes> filteredOutNodes = new ArrayList<NodeWithAttributes>();
                for (NodeWithAttributes dataNode : dataNodes) {
                    if (filteredDataNodes.contains(dataNode.nodeName())) {
                        matchedNodes.add(dataNode);
                        continue;
                    }
                    filteredOutNodes.add(dataNode);
                }
                if (!filteredOutNodes.isEmpty() && !filteredDataNodes.isEmpty()) {
                    LOG.info("Some data nodes were filtered out because they don't match zone's attributes:\n\tzoneId={}\n\tfilter={}\n\tstorageProfiles={}'\n\tfilteredOutNodes={}\n\tremainingNodes={}", new Object[]{zoneDescriptor.id(), zoneDescriptor.filter(), zoneDescriptor.storageProfiles(), filteredOutNodes, matchedNodes});
                }
            }
            if (filteredDataNodes.isEmpty()) {
                LOG.info("Rebalance is not triggered because data nodes are empty [zoneId={}, filter={}, storageProfiles={}]", new Object[]{zoneDescriptor.id(), zoneDescriptor.filter(), zoneDescriptor.storageProfiles().profiles()});
                return CompletableFutures.nullCompletedFuture();
            }
            return this.triggerPartitionsRebalanceForAllTables(evt.entryEvent().newEntry().revision(), evt.entryEvent().newEntry().timestamp(), zoneDescriptor, filteredDataNodes, catalog.tables(zoneId), assignmentsTimestamp);
        });
    }

    private CompletableFuture<Void> onUpdateReplicas(AlterZoneEventParameters parameters) {
        return this.recalculateAssignmentsAndScheduleRebalance(parameters.zoneDescriptor(), parameters.causalityToken(), parameters.zoneDescriptor().updateTimestamp(), parameters.catalogVersion());
    }

    private CompletableFuture<Void> recalculateAssignmentsAndScheduleRebalance(CatalogZoneDescriptor zoneDescriptor, long causalityToken, HybridTimestamp timestamp, int catalogVersion) {
        return this.distributionZoneManager.dataNodes(timestamp, catalogVersion, zoneDescriptor.id()).thenCompose(dataNodes -> {
            if (dataNodes.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            Catalog catalog = this.catalogService.catalog(catalogVersion);
            return this.triggerPartitionsRebalanceForAllTables(causalityToken, timestamp, zoneDescriptor, (Set<String>)dataNodes, catalog.tables(zoneDescriptor.id()), catalog.time());
        });
    }

    private CompletableFuture<Void> triggerPartitionsRebalanceForAllTables(long revision, HybridTimestamp timestamp, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, Collection<CatalogTableDescriptor> tableDescriptors, long assignmentsTimestamp) {
        ArrayList<CompletableFuture<Void>> tableFutures = new ArrayList<CompletableFuture<Void>>(tableDescriptors.size());
        Set<String> aliveNodes = DistributionZonesUtil.nodeNames(this.distributionZoneManager.logicalTopology(revision));
        for (CatalogTableDescriptor tableDescriptor : tableDescriptors) {
            tableFutures.add(RebalanceUtil.triggerAllTablePartitionsRebalance(tableDescriptor, zoneDescriptor, dataNodes, revision, timestamp, this.metaStorageManager, assignmentsTimestamp, aliveNodes));
        }
        return CompletableFuture.allOf((CompletableFuture[])tableFutures.toArray(CompletableFuture[]::new));
    }
}

