/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StreamUtils;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.qualifiers.TypeArgumentQualifier;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Internal
public class ClosestTypeArgumentQualifier<T>
extends TypeArgumentQualifier<T> {
    private static final Logger LOG = ClassUtils.getLogger(ClosestTypeArgumentQualifier.class);
    private final List<Class>[] hierarchies;

    ClosestTypeArgumentQualifier(Class ... typeArguments) {
        super(typeArguments);
        this.hierarchies = new List[typeArguments.length];
        for (int i = 0; i < typeArguments.length; ++i) {
            this.hierarchies[i] = ClassUtils.resolveHierarchy((Class)typeArguments[i]);
        }
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return ((List)candidates.filter(candidate -> beanType.isAssignableFrom(candidate.getBeanType())).map(candidate -> {
            List<Class> typeArguments = this.getTypeArguments(beanType, candidate);
            int result = this.compare(typeArguments);
            if (LOG.isTraceEnabled() && result < 0) {
                LOG.trace("Bean type {} is not compatible with candidate generic types [{}] of candidate {}", new Object[]{beanType, CollectionUtils.toString(typeArguments), candidate});
            }
            return new AbstractMap.SimpleEntry<BeanType, Integer>((BeanType)candidate, result);
        }).filter(entry -> (Integer)entry.getValue() > -1).collect(StreamUtils.minAll(Comparator.comparingInt(Map.Entry::getValue), Collectors.toList()))).stream().map(Map.Entry::getKey);
    }

    protected int compare(List<Class> classesToCompare) {
        Class[] typeArguments = this.getTypeArguments();
        if (classesToCompare.isEmpty() && typeArguments.length == 0) {
            return 0;
        }
        if (classesToCompare.size() != typeArguments.length) {
            return -1;
        }
        int comparison = 0;
        for (int i = 0; i < classesToCompare.size(); ++i) {
            if (typeArguments[i] == Object.class) continue;
            List<Class> hierarchy = this.hierarchies[i];
            Class left = classesToCompare.get(i);
            int index = hierarchy.indexOf(left);
            if (index == -1) {
                comparison = -1;
                break;
            }
            comparison += index;
        }
        return comparison;
    }
}

