/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class HandshakeStartResponseMessageDeserializer
implements MessageDeserializer<HandshakeStartResponseMessage> {
    private final HandshakeStartResponseMessageBuilder msg;

    HandshakeStartResponseMessageDeserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeStartResponseMessage();
    }

    public Class<HandshakeStartResponseMessage> klass() {
        return HandshakeStartResponseMessage.class;
    }

    public HandshakeStartResponseMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ClusterNodeMessage tmp = (ClusterNodeMessage)reader.readMessage("clientNode");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.clientNode(tmp);
                reader.incrementState();
            }
            case 1: {
                short tmp = reader.readShort("connectionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.connectionId(tmp);
                reader.incrementState();
            }
            case 2: {
                long tmp = reader.readLong("receivedCount");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.receivedCount(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeStartResponseMessage.class);
    }
}

