/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import org.apache.ignite.internal.network.message.ClassDescriptorMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorMessageImpl;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class ClassDescriptorMessageSerializer
implements MessageSerializer<ClassDescriptorMessage> {
    public static final ClassDescriptorMessageSerializer INSTANCE = new ClassDescriptorMessageSerializer();

    private ClassDescriptorMessageSerializer() {
    }

    public boolean writeMessage(ClassDescriptorMessage msg, MessageWriter writer) throws MessageMappingException {
        ClassDescriptorMessageImpl message = (ClassDescriptorMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)10)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByte("attributes", message.attributes());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("className", message.className());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeInt("componentTypeDescriptorId", message.componentTypeDescriptorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("componentTypeName", message.componentTypeName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeInt("descriptorId", message.descriptorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeCollection("fields", message.fields(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeByte("serializationFlags", message.serializationFlags());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeByte("serializationType", message.serializationType());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeInt("superClassDescriptorId", message.superClassDescriptorId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                boolean written = writer.writeString("superClassName", message.superClassName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

