/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessageBuilder;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class TablePartitionIdMessageImpl
implements TablePartitionIdMessage,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 42;
    @IgniteToStringInclude
    private final int partitionId;
    @IgniteToStringInclude
    private final int tableId;

    private TablePartitionIdMessageImpl(int partitionId, int tableId) {
        this.partitionId = partitionId;
        this.tableId = tableId;
    }

    @Override
    public int partitionId() {
        return this.partitionId;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public MessageSerializer serializer() {
        return TablePartitionIdMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(TablePartitionIdMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 42;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TablePartitionIdMessageImpl otherMessage = (TablePartitionIdMessageImpl)other;
        return this.partitionId == otherMessage.partitionId && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.partitionId, this.tableId);
        return result;
    }

    public TablePartitionIdMessageImpl clone() {
        try {
            return (TablePartitionIdMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TablePartitionIdMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements TablePartitionIdMessageBuilder {
        private int partitionId;
        private int tableId;

        private Builder() {
        }

        @Override
        public TablePartitionIdMessageBuilder partitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public TablePartitionIdMessageBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public int partitionId() {
            return this.partitionId;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public TablePartitionIdMessage build() {
            return new TablePartitionIdMessageImpl(this.partitionId, this.tableId);
        }
    }
}

