/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.io.PageIo;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.DirtyFullPageId;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PageStoreWriter;
import org.apache.ignite.internal.pagememory.persistence.PartitionDestructionLockManager;
import org.apache.ignite.internal.pagememory.persistence.PartitionMeta;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.WriteDirtyPage;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointDirtyPages;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.pagememory.persistence.io.PartitionMetaIo;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.apache.ignite.internal.util.IgniteConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CheckpointPagesWriter
implements Runnable {
    private static final IgniteLogger LOG = Loggers.forClass(CheckpointPagesWriter.class);
    private static final int MAX_ATTEMPT_WRITE_RETRY_DIRTY_PAGES = 32;
    private static final int CP_BUFFER_PAGES_BATCH_THRESHOLD = 10;
    private final CheckpointMetricsTracker tracker;
    private final IgniteConcurrentMultiPairQueue<PersistentPageMemory, GroupPartitionId> dirtyPartitionQueue;
    private final List<PersistentPageMemory> pageMemoryList;
    private final ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions;
    private final CompletableFuture<?> doneFut;
    private final Runnable updateHeartbeat;
    private final ThreadLocal<ByteBuffer> threadBuf;
    private final CheckpointProgressImpl checkpointProgress;
    private final WriteDirtyPage pageWriter;
    private final PageIoRegistry ioRegistry;
    private final PartitionMetaManager partitionMetaManager;
    private final BooleanSupplier shutdownNow;
    private final PartitionDestructionLockManager partitionDestructionLockManager;

    CheckpointPagesWriter(CheckpointMetricsTracker tracker, IgniteConcurrentMultiPairQueue<PersistentPageMemory, GroupPartitionId> dirtyPartitionQueue, List<PersistentPageMemory> pageMemoryList, ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions, CompletableFuture<?> doneFut, Runnable updateHeartbeat, ThreadLocal<ByteBuffer> threadBuf, CheckpointProgressImpl checkpointProgress, WriteDirtyPage pageWriter, PageIoRegistry ioRegistry, PartitionMetaManager partitionMetaManager, BooleanSupplier shutdownNow, PartitionDestructionLockManager partitionDestructionLockManager) {
        this.tracker = tracker;
        this.dirtyPartitionQueue = dirtyPartitionQueue;
        this.pageMemoryList = pageMemoryList;
        this.updatedPartitions = updatedPartitions;
        this.doneFut = doneFut;
        this.updateHeartbeat = updateHeartbeat;
        this.threadBuf = threadBuf;
        this.checkpointProgress = checkpointProgress;
        this.pageWriter = pageWriter;
        this.ioRegistry = ioRegistry;
        this.partitionMetaManager = partitionMetaManager;
        this.shutdownNow = shutdownNow;
        this.partitionDestructionLockManager = partitionDestructionLockManager;
    }

    @Override
    public void run() {
        try {
            Map<PersistentPageMemory, List<DirtyFullPageId>> pageIdsToRetry = new HashMap<PersistentPageMemory, List<DirtyFullPageId>>();
            ByteBuffer tmpWriteBuf = this.threadBuf.get();
            IgniteConcurrentMultiPairQueue.Result queueResult = new IgniteConcurrentMultiPairQueue.Result();
            while (!this.shutdownNow.getAsBoolean() && this.dirtyPartitionQueue.next(queueResult)) {
                this.updateHeartbeat.run();
                PersistentPageMemory pageMemory = (PersistentPageMemory)queueResult.getKey();
                PageStoreWriter pageStoreWriter = this.createPageStoreWriter(pageMemory, pageIdsToRetry);
                this.writeDirtyPages(pageMemory, (GroupPartitionId)queueResult.getValue(), tmpWriteBuf, pageStoreWriter);
            }
            int attemptWriteRetryDirtyPages = 0;
            while (!this.shutdownNow.getAsBoolean() && !pageIdsToRetry.isEmpty()) {
                this.updateHeartbeat.run();
                pageIdsToRetry = this.writeRetryDirtyPages(pageIdsToRetry, tmpWriteBuf, attemptWriteRetryDirtyPages++);
            }
            this.doneFut.complete(null);
        }
        catch (Throwable e) {
            this.doneFut.completeExceptionally(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDirtyPages(PersistentPageMemory pageMemory, GroupPartitionId partitionId, ByteBuffer tmpWriteBuf, PageStoreWriter pageStoreWriter) throws IgniteInternalCheckedException {
        CheckpointDirtyPages.CheckpointDirtyPagesView checkpointDirtyPagesView = this.checkpointDirtyPagesView(pageMemory, partitionId);
        Lock partitionDestructionLock = this.partitionDestructionLockManager.destructionLock(partitionId).readLock();
        partitionDestructionLock.lock();
        try {
            this.addUpdatePartitionCounterIfAbsent(partitionId);
            boolean isMetaWritten = false;
            for (int i = 0; i < checkpointDirtyPagesView.size() && !this.shutdownNow.getAsBoolean(); ++i) {
                this.updateHeartbeat.run();
                DirtyFullPageId pageId = checkpointDirtyPagesView.get(i);
                if (!isMetaWritten && this.isPartGenerationMatchWithMeta(pageId, partitionId)) {
                    this.writePartitionMeta(pageMemory, partitionId, tmpWriteBuf.rewind());
                    isMetaWritten = true;
                }
                this.writeDirtyPage(pageMemory, pageId, tmpWriteBuf, pageStoreWriter, true);
            }
        }
        finally {
            partitionDestructionLock.unlock();
        }
    }

    private void writeDirtyPage(PersistentPageMemory pageMemory, DirtyFullPageId pageId, ByteBuffer tmpWriteBuf, PageStoreWriter pageStoreWriter, boolean useTryWriteLockLockOnPage) throws IgniteInternalCheckedException {
        pageMemory.checkpointWritePage(pageId, tmpWriteBuf.rewind(), pageStoreWriter, this.tracker, useTryWriteLockLockOnPage);
        this.drainCheckpointBuffers(tmpWriteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<PersistentPageMemory, List<DirtyFullPageId>> writeRetryDirtyPages(Map<PersistentPageMemory, List<DirtyFullPageId>> pageIdsToRetry, ByteBuffer tmpWriteBuf, int attempt) throws IgniteInternalCheckedException {
        boolean useTryWriteLockOnPage;
        boolean bl = useTryWriteLockOnPage = attempt < 32;
        if (LOG.isInfoEnabled()) {
            int pageCount = pageIdsToRetry.values().stream().mapToInt(List::size).sum();
            LOG.info("Checkpoint pages were not written yet due to unsuccessful page write lock acquisition and will be retried: [pageCount={}, attempt={}, useTryWriteLockOnPage={}]", new Object[]{pageCount, attempt, useTryWriteLockOnPage});
        }
        HashMap<PersistentPageMemory, List<DirtyFullPageId>> newPageIdsToRetry = useTryWriteLockOnPage ? new HashMap<PersistentPageMemory, List<DirtyFullPageId>>() : Map.of();
        for (Map.Entry<PersistentPageMemory, List<DirtyFullPageId>> entry : pageIdsToRetry.entrySet()) {
            PersistentPageMemory pageMemory = entry.getKey();
            PageStoreWriter pageStoreWriter = this.createPageStoreWriter(pageMemory, newPageIdsToRetry);
            GroupPartitionId partitionId = null;
            Lock partitionDestructionLock = null;
            try {
                for (DirtyFullPageId pageId : entry.getValue()) {
                    if (this.shutdownNow.getAsBoolean()) {
                        Map<PersistentPageMemory, List<DirtyFullPageId>> map = Map.of();
                        return map;
                    }
                    this.updateHeartbeat.run();
                    if (CheckpointPagesWriter.partitionIdChanged(partitionId, pageId)) {
                        if (partitionDestructionLock != null) {
                            partitionDestructionLock.unlock();
                        }
                        partitionId = GroupPartitionId.convert(pageId);
                        partitionDestructionLock = this.partitionDestructionLockManager.destructionLock(partitionId).readLock();
                        partitionDestructionLock.lock();
                    }
                    this.writeDirtyPage(pageMemory, pageId, tmpWriteBuf, pageStoreWriter, useTryWriteLockOnPage);
                }
            }
            finally {
                if (partitionDestructionLock == null) continue;
                partitionDestructionLock.unlock();
            }
        }
        return newPageIdsToRetry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainCheckpointBuffers(ByteBuffer tmpWriteBuf) throws IgniteInternalCheckedException {
        boolean retry = true;
        while (retry) {
            retry = false;
            block4: for (PersistentPageMemory pageMemory : this.pageMemoryList) {
                int count = 0;
                PageStoreWriter pageStoreWriter = this.createPageStoreWriter(pageMemory, null);
                while (pageMemory.isCpBufferOverflowThresholdExceeded()) {
                    if (++count >= 10) {
                        retry = true;
                        continue block4;
                    }
                    this.updateHeartbeat.run();
                    DirtyFullPageId cpPageId = pageMemory.pullPageFromCpBuffer();
                    if (cpPageId.equals(DirtyFullPageId.NULL_PAGE)) continue block4;
                    GroupPartitionId partitionId = GroupPartitionId.convert(cpPageId);
                    Lock partitionDestructionLock = this.partitionDestructionLockManager.destructionLock(partitionId).readLock();
                    partitionDestructionLock.lock();
                    try {
                        this.addUpdatePartitionCounterIfAbsent(partitionId);
                        pageMemory.checkpointWritePage(cpPageId, tmpWriteBuf.rewind(), pageStoreWriter, this.tracker, true);
                    }
                    finally {
                        partitionDestructionLock.unlock();
                    }
                }
            }
        }
    }

    private void addUpdatePartitionCounterIfAbsent(GroupPartitionId partitionId) {
        if (!this.updatedPartitions.containsKey(partitionId)) {
            this.updatedPartitions.putIfAbsent(partitionId, new LongAdder());
        }
    }

    private boolean isPartGenerationMatchWithMeta(DirtyFullPageId pageId, GroupPartitionId partitionId) {
        PartitionMeta partitionMeta = this.partitionMetaManager.getMeta(partitionId);
        return partitionMeta != null && partitionMeta.partitionGeneration() == pageId.partitionGeneration();
    }

    private PageStoreWriter createPageStoreWriter(PersistentPageMemory pageMemory, @Nullable Map<PersistentPageMemory, List<DirtyFullPageId>> pagesToRetry) {
        return (fullPageId, buf, tag) -> {
            if (tag == -1) {
                if (pagesToRetry != null) {
                    pagesToRetry.computeIfAbsent(pageMemory, k -> new ArrayList()).add(fullPageId);
                }
                return;
            }
            long pageId = fullPageId.pageId();
            assert (PageIo.getType(buf) != 0) : "Invalid state. Type is 0! pageId = " + StringUtils.hexLong((long)pageId);
            assert (PageIo.getVersion(buf) != 0) : "Invalid state. Version is 0! pageId = " + StringUtils.hexLong((long)pageId);
            assert (fullPageId.pageIdx() != 0) : "Invalid pageIdx. Index is 0! pageId = " + StringUtils.hexLong((long)pageId);
            assert (!(this.ioRegistry.resolve(buf) instanceof PartitionMetaIo)) : "Invalid IO type. pageId = " + StringUtils.hexLong((long)pageId);
            if (PageIdUtils.flag(pageId) == 1) {
                this.tracker.onDataPageWritten();
            }
            this.checkpointProgress.writtenPagesCounter().incrementAndGet();
            this.pageWriter.write(pageMemory, fullPageId, buf);
            ((LongAdder)this.updatedPartitions.get(GroupPartitionId.convert(fullPageId))).increment();
        };
    }

    private void writePartitionMeta(PersistentPageMemory pageMemory, GroupPartitionId partitionId, ByteBuffer buffer) throws IgniteInternalCheckedException {
        PartitionMeta partitionMeta = this.partitionMetaManager.getMeta(partitionId);
        if (partitionMeta == null) {
            return;
        }
        PartitionMeta.PartitionMetaSnapshot partitionMetaSnapshot = partitionMeta.metaSnapshot(this.checkpointProgress.id());
        this.partitionMetaManager.writeMetaToBuffer(partitionId, partitionMetaSnapshot, buffer.rewind());
        DirtyFullPageId fullPageId = new DirtyFullPageId(PartitionMeta.partitionMetaPageId(partitionId.getPartitionId()), partitionId.getGroupId(), partitionMeta.partitionGeneration());
        this.pageWriter.write(pageMemory, fullPageId, buffer.rewind());
        this.checkpointProgress.writtenPagesCounter().incrementAndGet();
        ((LongAdder)this.updatedPartitions.get(partitionId)).increment();
        this.updateHeartbeat.run();
    }

    private CheckpointDirtyPages.CheckpointDirtyPagesView checkpointDirtyPagesView(PersistentPageMemory pageMemory, GroupPartitionId partitionId) {
        CheckpointDirtyPages checkpointDirtyPages = this.checkpointProgress.pagesToWrite();
        assert (checkpointDirtyPages != null);
        CheckpointDirtyPages.CheckpointDirtyPagesView partitionView = checkpointDirtyPages.getPartitionView(pageMemory, partitionId.getGroupId(), partitionId.getPartitionId());
        assert (partitionView != null) : String.format("Unable to find view for dirty pages: [partitionId=%s, pageMemory=%s]", partitionId, pageMemory);
        return partitionView;
    }

    private static boolean partitionIdChanged(@Nullable GroupPartitionId partitionId, FullPageId pageId) {
        return partitionId == null || partitionId.getGroupId() != pageId.groupId() || partitionId.getPartitionId() != pageId.partitionId();
    }
}

