/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.configuration;

import org.apache.ignite.internal.pagememory.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.pagememory.configuration.ReplacementMode;

public class PersistentDataRegionConfiguration
implements DataRegionConfiguration {
    private final String name;
    private final int pageSize;
    private final long size;
    private final ReplacementMode replacementMode;

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    public long sizeBytes() {
        return this.size;
    }

    public ReplacementMode replacementMode() {
        return this.replacementMode;
    }

    private PersistentDataRegionConfiguration(String name, int pageSize, long size, ReplacementMode replacementMode) {
        this.name = name;
        this.pageSize = pageSize;
        this.size = size;
        this.replacementMode = replacementMode;
    }

    public static PersistentDataRegionConfigurationBuilder builder() {
        return new PersistentDataRegionConfigurationBuilder();
    }

    public static class PersistentDataRegionConfigurationBuilder {
        private String name;
        private int pageSize;
        private long size;
        private ReplacementMode replacementMode = ReplacementMode.CLOCK;

        public PersistentDataRegionConfigurationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PersistentDataRegionConfigurationBuilder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PersistentDataRegionConfigurationBuilder size(long size) {
            this.size = size;
            return this;
        }

        public PersistentDataRegionConfigurationBuilder replacementMode(ReplacementMode replacementMode) {
            this.replacementMode = replacementMode;
            return this;
        }

        public PersistentDataRegionConfiguration build() {
            return new PersistentDataRegionConfiguration(this.name, this.pageSize, this.size, this.replacementMode);
        }
    }
}

