/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft.commands;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessageBuilder;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class ClusterNodeMessageDeserializer
implements MessageDeserializer<ClusterNodeMessage> {
    private final ClusterNodeMessageBuilder msg;

    ClusterNodeMessageDeserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.clusterNodeMessage();
    }

    public Class<ClusterNodeMessage> klass() {
        return ClusterNodeMessage.class;
    }

    public ClusterNodeMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readString("host");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.host((String)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readUuid("id");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.id((UUID)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readString("name");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.name((String)tmp);
                reader.incrementState();
            }
            case 3: {
                int tmp = reader.readInt("port");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.port(tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readList("storageProfiles", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.storageProfiles((List<String>)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readMap("systemAttributes", MessageCollectionItemType.STRING, MessageCollectionItemType.STRING, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.systemAttributes((Map<String, String>)tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readMap("userAttributes", MessageCollectionItemType.STRING, MessageCollectionItemType.STRING, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.userAttributes((Map<String, String>)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterNodeMessage.class);
    }
}

