/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.metrics;

import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.topology.LogicalTopology;
import org.apache.ignite.internal.metrics.AbstractMetricSource;
import org.apache.ignite.internal.metrics.IntGauge;
import org.apache.ignite.internal.metrics.Metric;
import org.apache.ignite.internal.metrics.StringGauge;
import org.apache.ignite.internal.metrics.UuidGauge;
import org.jetbrains.annotations.Nullable;

public class ClusterTopologyMetricsSource
extends AbstractMetricSource<Holder> {
    static final String SOURCE_NAME = "topology.cluster";
    private final LogicalTopology logicalTopology;
    private final Supplier<ClusterTag> clusterTagSupplier;

    public ClusterTopologyMetricsSource(LogicalTopology logicalTopology, Supplier<ClusterTag> clusterTagSupplier) {
        super(SOURCE_NAME, "Cluster topology metrics.", "topology");
        this.logicalTopology = logicalTopology;
        this.clusterTagSupplier = clusterTagSupplier;
    }

    protected Holder createHolder() {
        return new Holder();
    }

    public String clusterName() {
        Holder h = (Holder)this.holder();
        if (h == null) {
            return "";
        }
        return h.clusterName.value();
    }

    @Nullable
    public UUID clusterId() {
        Holder h = (Holder)this.holder();
        if (h == null) {
            return null;
        }
        return h.clusterId.value();
    }

    public int totalNodes() {
        Holder h = (Holder)this.holder();
        if (h == null) {
            return 0;
        }
        return h.clusterSize.value();
    }

    protected class Holder
    implements AbstractMetricSource.Holder<Holder> {
        private final IntGauge clusterSize = new IntGauge("TotalNodes", "Number of nodes in the logical topology", () -> ClusterTopologyMetricsSource.this.logicalTopology.getLogicalTopology().nodes().size());
        private final UuidGauge clusterId = new UuidGauge("ClusterId", "Unique identifier of the cluster", () -> {
            ClusterTag tag = ClusterTopologyMetricsSource.this.clusterTagSupplier.get();
            return tag != null ? tag.clusterId() : null;
        });
        private final StringGauge clusterName = new StringGauge("ClusterName", "Unique name of the cluster", () -> {
            ClusterTag tag = ClusterTopologyMetricsSource.this.clusterTagSupplier.get();
            return tag != null ? tag.clusterName() : "";
        });
        private final List<Metric> metrics = List.of(this.clusterId, this.clusterName, this.clusterSize);

        protected Holder() {
        }

        public Iterable<Metric> metrics() {
            return this.metrics;
        }
    }
}

