/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.proto.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.jdbc.proto.event.Response;
import org.apache.ignite.internal.tostring.S;

public class JdbcMetaSchemasResult
extends Response {
    private Collection<String> schemas;

    public JdbcMetaSchemasResult() {
    }

    public JdbcMetaSchemasResult(Collection<String> schemas) {
        Objects.requireNonNull(schemas);
        this.schemas = schemas;
    }

    @Override
    public void writeBinary(ClientMessagePacker packer) {
        super.writeBinary(packer);
        if (!this.success()) {
            return;
        }
        packer.packInt(this.schemas.size());
        for (String schema : this.schemas) {
            packer.packString(schema);
        }
    }

    @Override
    public void readBinary(ClientMessageUnpacker unpacker) {
        super.readBinary(unpacker);
        if (!this.success()) {
            return;
        }
        int size = unpacker.unpackInt();
        this.schemas = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            this.schemas.add(unpacker.unpackString());
        }
    }

    public Collection<String> schemas() {
        return this.schemas;
    }

    @Override
    public String toString() {
        return S.toString(JdbcMetaSchemasResult.class, (Object)this);
    }
}

