/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.graph;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.DirectedGraph;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class TopologicalOrderIterator<V, E extends DefaultEdge>
implements Iterator<V> {
    final Map<V, int[]> countMap = new HashMap<V, int[]>();
    final List<V> empties = new ArrayList<V>();
    final HepMatchOrder hepMatchOrder;
    private final DefaultDirectedGraph<V, E> graph;

    public TopologicalOrderIterator(DirectedGraph<V, E> graph) {
        this(graph, HepMatchOrder.TOP_DOWN);
    }

    public TopologicalOrderIterator(DirectedGraph<V, E> graph, HepMatchOrder hepMatchOrder) {
        assert (hepMatchOrder == HepMatchOrder.TOP_DOWN || hepMatchOrder == HepMatchOrder.BOTTOM_UP);
        this.graph = (DefaultDirectedGraph)graph;
        this.hepMatchOrder = hepMatchOrder;
        this.populate(this.countMap, this.empties);
    }

    public static <V, E extends DefaultEdge> Iterable<V> of(DirectedGraph<V, E> graph) {
        return () -> new TopologicalOrderIterator(graph);
    }

    public static <V, E extends DefaultEdge> Iterable<V> of(DirectedGraph<V, E> graph, HepMatchOrder hepMatchOrder) {
        return () -> new TopologicalOrderIterator(graph, hepMatchOrder);
    }

    @RequiresNonNull(value={"graph"})
    private void populate(@UnderInitialization TopologicalOrderIterator<V, E> this, Map<V, int[]> countMap, List<V> empties) {
        int[] ints;
        for (Object v : this.graph.vertexMap.keySet()) {
            countMap.put((int[])v, new int[]{0});
        }
        if (this.hepMatchOrder == HepMatchOrder.TOP_DOWN) {
            for (DefaultDirectedGraph.VertexInfo vertexInfo : this.graph.vertexMap.values()) {
                for (DefaultEdge edge : vertexInfo.outEdges) {
                    ints = Objects.requireNonNull(countMap.get(edge.target), () -> "no value for " + edge.target);
                    ints[0] = ints[0] + 1;
                }
            }
        }
        if (this.hepMatchOrder == HepMatchOrder.BOTTOM_UP) {
            for (DefaultDirectedGraph.VertexInfo vertexInfo : this.graph.vertexMap.values()) {
                for (DefaultEdge edge : vertexInfo.outEdges) {
                    ints = Objects.requireNonNull(countMap.get(edge.source), () -> "no value for " + edge.source);
                    ints[0] = ints[0] + 1;
                }
            }
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if (((int[])entry.getValue())[0] != 0) continue;
            empties.add(entry.getKey());
        }
        countMap.keySet().removeAll(empties);
    }

    @Override
    public boolean hasNext() {
        return !this.empties.isEmpty();
    }

    @Override
    public V next() {
        int[] ints;
        Object v = this.empties.remove(0);
        DefaultDirectedGraph.VertexInfo vertexInfo = Objects.requireNonNull(this.graph.vertexMap.get(v), () -> "no vertex " + v);
        if (this.hepMatchOrder == HepMatchOrder.TOP_DOWN) {
            for (DefaultEdge o : vertexInfo.outEdges) {
                Object target = o.target;
                (ints = Objects.requireNonNull(this.countMap.get((Object)target), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$next$5(java.lang.Object ), ()Ljava/lang/String;)((Object)target)))[0] = ints[0] - 1;
                if ((ints = Objects.requireNonNull(this.countMap.get((Object)target), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$next$5(java.lang.Object ), ()Ljava/lang/String;)((Object)target)))[0] != 0) continue;
                this.countMap.remove(target);
                this.empties.add(target);
            }
        }
        if (this.hepMatchOrder == HepMatchOrder.BOTTOM_UP) {
            for (DefaultEdge o : vertexInfo.inEdges) {
                Object source = o.source;
                (ints = Objects.requireNonNull(this.countMap.get((Object)source), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$next$6(java.lang.Object ), ()Ljava/lang/String;)((Object)source)))[0] = ints[0] - 1;
                if ((ints = Objects.requireNonNull(this.countMap.get((Object)source), (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$next$6(java.lang.Object ), ()Ljava/lang/String;)((Object)source)))[0] != 0) continue;
                this.countMap.remove(source);
                this.empties.add(source);
            }
        }
        return v;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    Set<V> findCycles() {
        while (this.hasNext()) {
            this.next();
        }
        return this.countMap.keySet();
    }

    private static /* synthetic */ String lambda$next$6(Object source) {
        return "no counts found for source " + source;
    }

    private static /* synthetic */ String lambda$next$5(Object target) {
        return "no counts found for target " + target;
    }
}

