/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format;

import java.time.ZonedDateTime;
import java.util.Set;
import java.util.function.Function;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.FormatPattern;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;
import org.apache.calcite.util.format.postgresql.format.compiled.NumberCompiledPattern;

public class NumberFormatPattern
extends FormatPattern {
    private final ChronoUnitEnum chronoUnit;
    private final Function<ZonedDateTime, Integer> dateTimeToIntFunction;
    private final Function<Integer, Integer> valueAdjuster;
    private final int minCharacters;
    private final int maxCharacters;
    private final int minValue;
    private final int maxValue;

    public NumberFormatPattern(String pattern, ChronoUnitEnum chronoUnit, Function<ZonedDateTime, Integer> dateTimeToIntConverter, Function<Integer, Integer> valueAdjuster, int minCharacters, int maxCharacters, int minValue, int maxValue) {
        super(pattern);
        this.chronoUnit = chronoUnit;
        this.dateTimeToIntFunction = dateTimeToIntConverter;
        this.valueAdjuster = valueAdjuster;
        this.minCharacters = minCharacters;
        this.maxCharacters = maxCharacters;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public NumberFormatPattern(String pattern, ChronoUnitEnum chronoUnit, Function<ZonedDateTime, Integer> dateTimeToIntConverter, int minCharacters, int maxCharacters, int minValue, int maxValue) {
        this(pattern, chronoUnit, dateTimeToIntConverter, v -> v, minCharacters, maxCharacters, minValue, maxValue);
    }

    @Override
    protected CompiledPattern buildCompiledPattern(Set<PatternModifier> modifiers) {
        return new NumberCompiledPattern(this.chronoUnit, this.dateTimeToIntFunction, this.valueAdjuster, this.minCharacters, this.maxCharacters, this.minValue, this.maxValue, this.pattern, modifiers);
    }
}

