/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;

public class SqlRowOperator
extends SqlSpecialOperator {
    public SqlRowOperator(String name) {
        super(name, SqlKind.ROW, 200, false, null, InferTypes.RETURN_TYPE, OperandTypes.VARIADIC);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (int index = 0; index < opBinding.getOperandCount(); ++index) {
            ((RelDataTypeFactory.Builder)builder).add(SqlUtil.deriveAliasFromOrdinal(index), opBinding.getOperandType(index));
        }
        RelDataType recordType = builder.build();
        boolean nullable = recordType.getFieldList().stream().allMatch(f -> f.getType().isNullable());
        return typeFactory.createTypeWithNullability(recordType, nullable);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlUtil.unparseFunctionSyntax(this, writer, call, false);
    }

    @Override
    public boolean requiresDecimalExpansion() {
        return false;
    }
}

