/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.config.NullCollation;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.RelToSqlConverterUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqliteSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.DUCKDB).withIdentifierQuoteString("\"").withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new SqliteSqlDialect(DEFAULT_CONTEXT);

    public SqliteSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, @Nullable SqlNode offset, @Nullable SqlNode fetch) {
        SqliteSqlDialect.unparseFetchUsingLimit(writer, offset, fetch);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case CHAR_LENGTH: {
                SqlCall lengthCall = SqlLibraryOperators.LENGTH.createCall(SqlParserPos.ZERO, call.getOperandList());
                super.unparseCall(writer, lengthCall, leftPrec, rightPrec);
                break;
            }
            case TRIM: {
                RelToSqlConverterUtil.unparseTrimLR(writer, call, leftPrec, rightPrec);
                break;
            }
            case POSITION: {
                SqlWriter.Frame frame = writer.startFunCall("INSTR");
                writer.sep(",");
                ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
                writer.sep(",");
                ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
                writer.endFunCall(frame);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }
}

