/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.streamer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.JobExecutionContext;
import org.apache.ignite.internal.client.proto.StreamerReceiverSerializer;
import org.apache.ignite.internal.compute.ComputeUtils;
import org.apache.ignite.internal.compute.JobExecutionContextImpl;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.table.DataStreamerReceiver;
import org.apache.ignite.table.DataStreamerReceiverContext;
import org.jetbrains.annotations.Nullable;

public class StreamerReceiverJob
implements ComputeJob<byte[], byte[]> {
    @Nullable
    public CompletableFuture<byte[]> executeAsync(JobExecutionContext context, byte @Nullable [] payload) {
        assert (payload != null) : "Streamer receiver job argument is null";
        ByteBuffer buf = ByteBuffer.wrap(payload).order(ByteOrder.LITTLE_ENDIAN);
        int payloadElementCount = buf.getInt();
        StreamerReceiverSerializer.SteamerReceiverInfo receiverInfo = StreamerReceiverSerializer.deserializeReceiverInfo((ByteBuffer)buf.slice().order(ByteOrder.LITTLE_ENDIAN), (int)payloadElementCount, receiverClassName -> {
            ClassLoader classLoader = ((JobExecutionContextImpl)context).classLoader().classLoader();
            Class receiverClass = ComputeUtils.receiverClass(classLoader, receiverClassName);
            return ComputeUtils.instantiateReceiver(receiverClass);
        });
        DataStreamerReceiverContext receiverContext = () -> ((JobExecutionContext)context).ignite();
        DataStreamerReceiver receiver = receiverInfo.receiver();
        CompletableFuture receiverRes = receiver.receive(receiverInfo.items(), receiverContext, receiverInfo.arg());
        if (receiverRes == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        return receiverRes.thenApply(r -> StreamerReceiverSerializer.serializeReceiverJobResults((List)r, (Marshaller)receiver.resultMarshaller()));
    }
}

