/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteStripedLock {
    private final Lock[] locks;

    public IgniteStripedLock(int concurrencyLevel) {
        this.locks = new Lock[concurrencyLevel];
        for (int i = 0; i < concurrencyLevel; ++i) {
            this.locks[i] = new ReentrantLock();
        }
    }

    public int concurrencyLevel() {
        return this.locks.length;
    }

    public Lock getLock(int key) {
        return this.locks[IgniteUtils.safeAbs(key) % this.locks.length];
    }

    public Lock getLock(long key) {
        return this.locks[IgniteUtils.safeAbs((int)(key % (long)this.locks.length))];
    }

    public Lock getLock(@Nullable Object o) {
        return o == null ? this.locks[0] : this.getLock(o.hashCode());
    }

    public void lock(int key) {
        this.getLock(key).lock();
    }

    public void lock(long key) {
        this.getLock(key).lock();
    }

    public void lock(@Nullable Object o) {
        this.getLock(o).lock();
    }

    public void unlock(int key) {
        this.getLock(key).unlock();
    }

    public void unlock(long key) {
        this.getLock(key).unlock();
    }

    public void unlock(@Nullable Object o) {
        this.getLock(o).unlock();
    }

    public String toString() {
        return S.toString(IgniteStripedLock.class, this, "concurrency", (Object)this.locks.length);
    }
}

