/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.logger;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.jetbrains.annotations.Nullable;

class IgniteLoggerImpl
implements IgniteLogger {
    final System.Logger delegate;

    IgniteLoggerImpl(System.Logger delegate) {
        this.delegate = delegate;
    }

    @Override
    public void info(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.INFO, msg, null, params);
    }

    @Override
    public void info(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.INFO, msg, th, params);
    }

    @Override
    public void info(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternalExceptional(System.Logger.Level.INFO, msgSupplier, th);
    }

    @Override
    public void info(String msg, @Nullable Throwable th) {
        this.delegate.log(System.Logger.Level.INFO, msg, th);
    }

    @Override
    public void debug(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.DEBUG, msg, null, params);
    }

    @Override
    public void debug(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.DEBUG, msg, th, params);
    }

    @Override
    public void debug(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternalExceptional(System.Logger.Level.DEBUG, msgSupplier, th);
    }

    @Override
    public void debug(String msg, @Nullable Throwable th) {
        this.delegate.log(System.Logger.Level.DEBUG, msg, th);
    }

    @Override
    public void warn(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.WARNING, msg, null, params);
    }

    @Override
    public void warn(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.WARNING, msg, th, params);
    }

    @Override
    public void warn(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternalExceptional(System.Logger.Level.WARNING, msgSupplier, th);
    }

    @Override
    public void warn(String msg, @Nullable Throwable th) {
        this.delegate.log(System.Logger.Level.WARNING, msg, th);
    }

    @Override
    public void error(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.ERROR, msg, null, params);
    }

    @Override
    public void error(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.ERROR, msg, th, params);
    }

    @Override
    public void error(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternalExceptional(System.Logger.Level.ERROR, msgSupplier, th);
    }

    @Override
    public void error(String msg, @Nullable Throwable th) {
        this.delegate.log(System.Logger.Level.ERROR, msg, th);
    }

    @Override
    public void trace(String msg, Object ... params) {
        this.logInternal(System.Logger.Level.TRACE, msg, null, params);
    }

    @Override
    public void trace(String msg, @Nullable Throwable th, Object ... params) {
        this.logInternal(System.Logger.Level.TRACE, msg, th, params);
    }

    @Override
    public void trace(Supplier<String> msgSupplier, @Nullable Throwable th) {
        this.logInternalExceptional(System.Logger.Level.TRACE, msgSupplier, th);
    }

    @Override
    public void trace(String msg, @Nullable Throwable th) {
        this.delegate.log(System.Logger.Level.TRACE, msg, th);
    }

    private void logInternal(System.Logger.Level level, String msg, @Nullable Throwable th, Object ... params) {
        Objects.requireNonNull(level);
        if (!this.delegate.isLoggable(level)) {
            return;
        }
        if (th != null) {
            this.delegate.log(level, IgniteStringFormatter.format(msg, params), th);
        } else {
            this.delegate.log(level, IgniteStringFormatter.format(msg, params));
        }
    }

    private void logInternalExceptional(System.Logger.Level level, Supplier<String> msgSupplier, @Nullable Throwable th) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(msgSupplier);
        if (!this.delegate.isLoggable(level)) {
            return;
        }
        this.delegate.log(level, msgSupplier.get(), th);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.TRACE);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.DEBUG);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isLoggable(System.Logger.Level.WARNING);
    }
}

