/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.tostring.S;

public class DropSchemaEntry
implements UpdateEntry {
    private final int schemaId;

    public DropSchemaEntry(int schemaId) {
        this.schemaId = schemaId;
    }

    public int schemaId() {
        return this.schemaId;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DROP_SCHEMA.id();
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), catalog.schemas().stream().filter(s -> s.id() != this.schemaId).collect(Collectors.toList()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

