/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.utils;

import java.util.function.Function;
import java.util.function.ObjLongConsumer;
import org.apache.ignite.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite.internal.configuration.SystemDistributedView;
import org.apache.ignite.internal.configuration.SystemPropertyView;
import org.apache.ignite.internal.util.CompletableFutures;

public class SystemDistributedConfigurationPropertyHolder<T> {
    private final String propertyName;
    private final T defaultValue;
    private final SystemDistributedConfiguration systemDistributedConfig;
    private volatile T currentValue;
    private final ObjLongConsumer<T> valueListener;
    private final Function<String, T> propertyConverter;

    public SystemDistributedConfigurationPropertyHolder(SystemDistributedConfiguration systemDistributedConfig, ObjLongConsumer<T> valueListener, String propertyName, T defaultValue, Function<String, T> propertyConverter) {
        this.systemDistributedConfig = systemDistributedConfig;
        this.valueListener = valueListener;
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.propertyConverter = propertyConverter;
        systemDistributedConfig.listen(ctx -> {
            this.updateSystemProperties((SystemDistributedView)ctx.newValue(), ctx.storageRevision());
            return CompletableFutures.nullCompletedFuture();
        });
    }

    public void init() {
        this.updateSystemProperties((SystemDistributedView)this.systemDistributedConfig.value(), -1L);
    }

    public T currentValue() {
        return this.currentValue;
    }

    private void updateSystemProperties(SystemDistributedView view, long revision) {
        SystemPropertyView systemPropertyView = (SystemPropertyView)view.properties().get(this.propertyName);
        T value = systemPropertyView == null ? this.defaultValue : this.propertyConverter.apply(systemPropertyView.propertyValue());
        this.currentValue = value;
        if (revision != -1L) {
            this.valueListener.accept(value, revision);
        }
    }
}

