/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.sql;

import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.shaded.org.apache.ignite.internal.sql.StatementImpl;
import org.apache.ignite.shaded.org.apache.ignite.sql.Statement;

public class StatementBuilderImpl
implements Statement.StatementBuilder {
    private String query;
    private String defaultSchema;
    private Long queryTimeoutMs;
    private Integer pageSize;
    private ZoneId timeZoneId;

    @Override
    public Statement.StatementBuilder query(String query) {
        this.query = Objects.requireNonNull(query, "query");
        return this;
    }

    @Override
    public Statement.StatementBuilder queryTimeout(long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit");
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be positive: " + timeout);
        }
        this.queryTimeoutMs = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        return this;
    }

    @Override
    public Statement.StatementBuilder defaultSchema(String schema) {
        this.defaultSchema = Objects.requireNonNull(schema, "schema");
        return this;
    }

    @Override
    public Statement.StatementBuilder pageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Page size must be positive: " + pageSize);
        }
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public Statement.StatementBuilder timeZoneId(ZoneId timeZoneId) {
        this.timeZoneId = Objects.requireNonNull(timeZoneId, "timeZoneId");
        return this;
    }

    @Override
    public Statement build() {
        return new StatementImpl(this.query, this.defaultSchema, this.queryTimeoutMs, this.pageSize, this.timeZoneId);
    }
}

