/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import org.apache.hc.core5.net.Host;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHost {
    TestHost() {
    }

    @Test
    void testConstructor() {
        Host host1 = new Host("somehost", 8080);
        Assertions.assertEquals((Object)"somehost", (Object)host1.getHostName());
        Assertions.assertEquals((int)8080, (int)host1.getPort());
        Host host2 = new Host("somehost", 0);
        Assertions.assertEquals((Object)"somehost", (Object)host2.getHostName());
        Assertions.assertEquals((int)0, (int)host2.getPort());
        Host host3 = new Host("\u042f\u043d\u0434\u0435\u043a\u0441.\u0420\u0443", 0);
        Assertions.assertEquals((Object)"\u042f\u043d\u0434\u0435\u043a\u0441.\u0420\u0443", (Object)host3.getHostName());
        Assertions.assertEquals((int)0, (int)host3.getPort());
        Host host4 = new Host("xn--d1acpjx3f.xn--p1ag", 0);
        Assertions.assertEquals((Object)"\u044f\u043d\u0434\u0435\u043a\u0441.\u0440\u0443", (Object)host4.getHostName());
        Assertions.assertEquals((int)0, (int)host4.getPort());
        Host host5 = new Host("XN--D1Acpjx3f.xn--p1ag", 0);
        Assertions.assertEquals((Object)"\u044f\u043d\u0434\u0435\u043a\u0441.\u0440\u0443", (Object)host5.getHostName());
        Assertions.assertEquals((int)0, (int)host5.getPort());
        Assertions.assertThrows(NullPointerException.class, () -> new Host(null, 0));
    }

    @Test
    void testHashCode() {
        Host host1 = new Host("somehost", 8080);
        Host host2 = new Host("somehost", 80);
        Host host3 = new Host("someotherhost", 8080);
        Host host4 = new Host("somehost", 80);
        Assertions.assertEquals((int)host1.hashCode(), (int)host1.hashCode());
        Assertions.assertNotEquals((int)host1.hashCode(), (int)host2.hashCode());
        Assertions.assertNotEquals((int)host1.hashCode(), (int)host3.hashCode());
        Assertions.assertEquals((int)host2.hashCode(), (int)host4.hashCode());
    }

    @Test
    void testEquals() {
        Host host1 = new Host("somehost", 8080);
        Host host2 = new Host("somehost", 80);
        Host host3 = new Host("someotherhost", 8080);
        Host host4 = new Host("somehost", 80);
        Assertions.assertEquals((Object)host1, (Object)host1);
        Assertions.assertNotEquals((Object)host1, (Object)host2);
        Assertions.assertNotEquals((Object)host1, (Object)host3);
        Assertions.assertEquals((Object)host2, (Object)host4);
    }

    @Test
    void testToString() {
        Host host1 = new Host("somehost", 8888);
        Assertions.assertEquals((Object)"somehost:8888", (Object)host1.toString());
    }

    @Test
    void testSerialization() throws Exception {
        Host orig = new Host("somehost", 8080);
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
        }
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        Host clone = (Host)inStream.readObject();
        Assertions.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    void testCreateFromString() throws Exception {
        Assertions.assertEquals((Object)new Host("somehost", 8080), (Object)Host.create((String)"somehost:8080"));
        Assertions.assertEquals((Object)new Host("somehost", 1234), (Object)Host.create((String)"somehost:1234"));
        Assertions.assertEquals((Object)new Host("somehost", 0), (Object)Host.create((String)"somehost:0"));
        Assertions.assertEquals((Object)new Host("\u044f\u043d\u0434\u0435\u043a\u0441.\u0440\u0443", -1), (Object)Host.create((String)"xn--d1acpjx3f.xn--p1ag"));
        Assertions.assertEquals((Object)new Host("\u042f\u043d\u0434\u0435\u043a\u0441.\u0420\u0443", -1), (Object)Host.create((String)"\u042f\u043d\u0434\u0435\u043a\u0441.\u0420\u0443"));
    }

    @Test
    void testCreateFromStringInvalid() {
        Assertions.assertThrows(URISyntaxException.class, () -> Host.create((String)" host "));
        Assertions.assertThrows(URISyntaxException.class, () -> Host.create((String)"host :8080"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Host.create((String)""));
    }

    @Test
    void testIpv6HostAndPort() throws Exception {
        Host host = Host.create((String)"[::1]:80");
        Assertions.assertEquals((Object)"::1", (Object)host.getHostName());
        Assertions.assertEquals((int)80, (int)host.getPort());
    }

    @Test
    void testIpv6HostAndPortWithoutBrackets() {
        Assertions.assertThrows(URISyntaxException.class, () -> Host.create((String)"::1:80"));
    }

    @Test
    void testIpv6HostWithoutPort() {
        Assertions.assertThrows(URISyntaxException.class, () -> Host.create((String)"::1"));
    }

    @Test
    void testIpv6HostToString() {
        Assertions.assertEquals((Object)"[::1]:80", (Object)new Host("::1", 80).toString());
        Assertions.assertEquals((Object)"[::1]", (Object)new Host("::1", -1).toString());
    }
}

