/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.core.TestEngineFormatter;

class EngineFilterer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineFilterer.class);
    private final List<EngineFilter> engineFilters;
    private final Map<TestEngine, Boolean> checkedTestEngines = new HashMap<TestEngine, Boolean>();

    EngineFilterer(List<EngineFilter> engineFilters) {
        this.engineFilters = engineFilters;
    }

    boolean isExcluded(TestEngine testEngine) {
        boolean excluded = this.engineFilters.stream().map(engineFilter -> engineFilter.apply(testEngine)).anyMatch(FilterResult::excluded);
        this.checkedTestEngines.put(testEngine, excluded);
        return excluded;
    }

    void performSanityChecks() {
        this.checkNoUnmatchedIncludeFilter();
        this.warnIfAllEnginesExcluded();
    }

    private void warnIfAllEnginesExcluded() {
        if (!this.checkedTestEngines.isEmpty() && this.checkedTestEngines.values().stream().allMatch(excluded -> excluded)) {
            LOGGER.warn(() -> "All TestEngines were excluded by EngineFilters.\n" + this.getStateDescription());
        }
    }

    private void checkNoUnmatchedIncludeFilter() {
        SortedSet<String> unmatchedEngineIdsOfIncludeFilters = this.getUnmatchedEngineIdsOfIncludeFilters();
        if (!unmatchedEngineIdsOfIncludeFilters.isEmpty()) {
            throw new JUnitException("No TestEngine ID matched the following include EngineFilters: " + unmatchedEngineIdsOfIncludeFilters + ".\nPlease fix/remove the filter or add the engine.\n" + this.getStateDescription());
        }
    }

    private SortedSet<String> getUnmatchedEngineIdsOfIncludeFilters() {
        Set checkedTestEngineIds = this.checkedTestEngines.keySet().stream().map(TestEngine::getId).collect(Collectors.toSet());
        return this.engineFilters.stream().filter(EngineFilter::isIncludeFilter).map(EngineFilter::getEngineIds).flatMap(Collection::stream).filter(id -> !checkedTestEngineIds.contains(id)).collect(Collectors.toCollection(TreeSet::new));
    }

    private String getStateDescription() {
        return this.getRegisteredEnginesDescription() + "\n" + this.getRegisteredFiltersDescription();
    }

    private String getRegisteredEnginesDescription() {
        return TestEngineFormatter.format("Registered TestEngines", this.checkedTestEngines.keySet());
    }

    private String getRegisteredFiltersDescription() {
        return "Registered EngineFilters:" + this.engineFilters.stream().map(Objects::toString).collect(Collectors.joining("\n- ", "\n- ", ""));
    }
}

