/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.partition.spec;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;

public class CompositePartitionSpecProxy
extends PartitionSpecProxy {
    private String dbName;
    private String tableName;
    private List<PartitionSpec> partitionSpecs;
    private List<PartitionSpecProxy> partitionSpecProxies;
    private int size = 0;

    protected CompositePartitionSpecProxy(List<PartitionSpec> partitionSpecs) {
        this.partitionSpecs = partitionSpecs;
        if (partitionSpecs.isEmpty()) {
            this.dbName = null;
            this.tableName = null;
        } else {
            this.dbName = partitionSpecs.get(0).getDbName();
            this.tableName = partitionSpecs.get(0).getTableName();
            this.partitionSpecProxies = new ArrayList<PartitionSpecProxy>(partitionSpecs.size());
            for (PartitionSpec partitionSpec : partitionSpecs) {
                PartitionSpecProxy partitionSpecProxy = PartitionSpecProxy.Factory.get(partitionSpec);
                this.partitionSpecProxies.add(partitionSpecProxy);
                this.size += partitionSpecProxy.size();
            }
        }
        assert (this.isValid()) : "Invalid CompositePartitionSpecProxy!";
    }

    protected CompositePartitionSpecProxy(String dbName, String tableName, List<PartitionSpec> partitionSpecs) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.partitionSpecs = partitionSpecs;
        this.partitionSpecProxies = new ArrayList<PartitionSpecProxy>(partitionSpecs.size());
        for (PartitionSpec partitionSpec : partitionSpecs) {
            this.partitionSpecProxies.add(PartitionSpecProxy.Factory.get(partitionSpec));
        }
        assert (this.isValid()) : "Invalid CompositePartitionSpecProxy!";
    }

    private boolean isValid() {
        for (PartitionSpecProxy partitionSpecProxy : this.partitionSpecProxies) {
            if (!(partitionSpecProxy instanceof CompositePartitionSpecProxy)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void setDbName(String dbName) {
        this.dbName = dbName;
        for (PartitionSpecProxy partSpecProxy : this.partitionSpecProxies) {
            partSpecProxy.setDbName(dbName);
        }
    }

    @Override
    public void setTableName(String tableName) {
        this.tableName = tableName;
        for (PartitionSpecProxy partSpecProxy : this.partitionSpecProxies) {
            partSpecProxy.setTableName(tableName);
        }
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public PartitionSpecProxy.PartitionIterator getPartitionIterator() {
        return new Iterator(this);
    }

    @Override
    public List<PartitionSpec> toPartitionSpec() {
        return this.partitionSpecs;
    }

    @Override
    public void setRootLocation(String rootLocation) throws MetaException {
        for (PartitionSpecProxy partSpecProxy : this.partitionSpecProxies) {
            partSpecProxy.setRootLocation(rootLocation);
        }
    }

    public static class Iterator
    implements PartitionSpecProxy.PartitionIterator {
        private CompositePartitionSpecProxy composite;
        private List<PartitionSpecProxy> partitionSpecProxies;
        private int index = -1;
        private PartitionSpecProxy.PartitionIterator iterator = null;

        public Iterator(CompositePartitionSpecProxy composite) {
            this.composite = composite;
            this.partitionSpecProxies = composite.partitionSpecProxies;
            if (this.partitionSpecProxies != null && !this.partitionSpecProxies.isEmpty()) {
                this.index = 0;
                this.iterator = this.partitionSpecProxies.get(this.index).getPartitionIterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null) {
                return false;
            }
            if (this.iterator.hasNext()) {
                return true;
            }
            while (++this.index < this.partitionSpecProxies.size() && !(this.iterator = this.partitionSpecProxies.get(this.index).getPartitionIterator()).hasNext()) {
            }
            return this.index < this.partitionSpecProxies.size() && this.iterator.hasNext();
        }

        @Override
        public Partition next() {
            if (this.iterator.hasNext()) {
                return (Partition)this.iterator.next();
            }
            while (++this.index < this.partitionSpecProxies.size() && !(this.iterator = this.partitionSpecProxies.get(this.index).getPartitionIterator()).hasNext()) {
            }
            return this.index == this.partitionSpecProxies.size() ? null : (Partition)this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public Partition getCurrent() {
            return this.iterator.getCurrent();
        }

        @Override
        public String getDbName() {
            return this.composite.dbName;
        }

        @Override
        public String getTableName() {
            return this.composite.tableName;
        }

        @Override
        public Map<String, String> getParameters() {
            return this.iterator.getParameters();
        }

        @Override
        public void setParameters(Map<String, String> parameters) {
            this.iterator.setParameters(parameters);
        }

        @Override
        public String getLocation() {
            return this.iterator.getLocation();
        }

        @Override
        public void putToParameters(String key, String value) {
            this.iterator.putToParameters(key, value);
        }

        @Override
        public void setCreateTime(long time) {
            this.iterator.setCreateTime(time);
        }
    }
}

