/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;

@PublicEvolving
public class CatalogColumnStatisticsDataDouble
extends CatalogColumnStatisticsDataBase {
    private final Double min;
    private final Double max;
    private final Long ndv;

    public CatalogColumnStatisticsDataDouble(Double min, Double max, Long ndv, Long nullCount) {
        super(nullCount);
        this.min = min;
        this.max = max;
        this.ndv = ndv;
    }

    public CatalogColumnStatisticsDataDouble(Double min, Double max, Long ndv, Long nullCount, Map<String, String> properties) {
        super(nullCount, properties);
        this.min = min;
        this.max = max;
        this.ndv = ndv;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public Long getNdv() {
        return this.ndv;
    }

    @Override
    public CatalogColumnStatisticsDataDouble copy() {
        return new CatalogColumnStatisticsDataDouble(this.min, this.max, this.ndv, this.getNullCount(), new HashMap<String, String>(this.getProperties()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogColumnStatisticsDataDouble that = (CatalogColumnStatisticsDataDouble)o;
        return this.doubleCompare(this.min, that.min) && this.doubleCompare(this.max, that.max) && Objects.equals(this.ndv, that.ndv) && Objects.equals(this.getNullCount(), that.getNullCount());
    }

    private boolean doubleCompare(Double d1, Double d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        return Math.abs(d1 - d2) < 1.0E-6;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max, this.ndv, this.getNullCount());
    }

    public String toString() {
        return "CatalogColumnStatisticsDataDouble{min=" + this.min + ", max=" + this.max + ", ndv=" + this.ndv + ", nullCount=" + this.getNullCount() + '}';
    }
}

