/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.datadog;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.datadog.MetricMetaData;
import org.apache.flink.metrics.datadog.MetricType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class DMetric {
    @VisibleForTesting
    static final String FIELD_NAME_TYPE = "type";
    @VisibleForTesting
    static final String FIELD_NAME_METRIC = "metric";
    @VisibleForTesting
    static final String FIELD_NAME_HOST = "host";
    @VisibleForTesting
    static final String FIELD_NAME_TAGS = "tags";
    @VisibleForTesting
    static final String FIELD_NAME_POINTS = "points";
    private final MetricMetaData metaData;

    public DMetric(MetricMetaData metaData) {
        this.metaData = metaData;
    }

    @JsonGetter(value="type")
    public MetricType getType() {
        return this.metaData.getType();
    }

    @JsonGetter(value="metric")
    public String getMetricName() {
        return this.metaData.getMetricName();
    }

    @JsonGetter(value="host")
    public String getHost() {
        return this.metaData.getHost();
    }

    @JsonGetter(value="tags")
    public List<String> getTags() {
        return this.metaData.getTags();
    }

    @JsonGetter(value="points")
    public List<List<Number>> getPoints() {
        ArrayList<Number> point = new ArrayList<Number>();
        point.add(this.metaData.getClock().getUnixEpochTimestamp());
        point.add(this.getMetricValue());
        ArrayList<List<Number>> points = new ArrayList<List<Number>>();
        points.add(point);
        return points;
    }

    @JsonIgnore
    public abstract Number getMetricValue();

    public void ackReport() {
    }
}

