/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.optimize.StreamNonDeterministicUpdatePlanVisitor;
import org.apache.flink.util.Preconditions;

public class StreamNonDeterministicPhysicalPlanResolver {
    public static List<RelNode> resolvePhysicalPlan(List<RelNode> expanded, TableConfig tableConfig) {
        OptimizerConfigOptions.NonDeterministicUpdateStrategy handling = (OptimizerConfigOptions.NonDeterministicUpdateStrategy)tableConfig.getConfiguration().get(OptimizerConfigOptions.TABLE_OPTIMIZER_NONDETERMINISTIC_UPDATE_STRATEGY);
        if (handling == OptimizerConfigOptions.NonDeterministicUpdateStrategy.TRY_RESOLVE) {
            Preconditions.checkArgument((boolean)expanded.stream().allMatch(rel -> rel instanceof StreamPhysicalRel));
            StreamNonDeterministicUpdatePlanVisitor planResolver = new StreamNonDeterministicUpdatePlanVisitor();
            return expanded.stream().map(rel -> (StreamPhysicalRel)rel).map(planResolver::visit).collect(Collectors.toList());
        }
        return expanded;
    }
}

