/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.LookupJoinHintOptions;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.hint.JoinStrategy;
import org.apache.flink.table.planner.hint.QueryHintsRelShuttle;
import org.apache.flink.table.planner.hint.StateTtlHint;

public class QueryHintsResolver
extends QueryHintsRelShuttle {
    private final Set<RelHint> allHints = new HashSet<RelHint>();
    private final Set<RelHint> validHints = new HashSet<RelHint>();
    private final Map<String, Map<String, Boolean>> allOptionsInQueryHints = new HashMap<String, Map<String, Boolean>>();

    final List<RelNode> resolve(List<RelNode> roots) {
        List<RelNode> resolvedRoots = roots.stream().map(node -> node.accept(this)).collect(Collectors.toList());
        this.validateHints();
        return resolvedRoots;
    }

    @Override
    protected RelNode doVisit(RelNode node) {
        List<RelHint> newHints;
        ImmutableList<RelHint> oldHints = ((Hintable)((Object)node)).getHints();
        List<RelHint> oldQueryHints = FlinkHints.getAllQueryHints(oldHints);
        if (oldQueryHints.isEmpty()) {
            return super.visitChildren(node);
        }
        if (node instanceof BiRel) {
            BiRel biRel = (BiRel)node;
            Optional<String> leftName = this.extractAliasOrTableName(biRel.getLeft());
            Optional<String> rightName = this.extractAliasOrTableName(biRel.getRight());
            newHints = this.validateAndGetNewHints(leftName, rightName, oldHints);
        } else if (node instanceof SingleRel) {
            SingleRel singleRel = (SingleRel)node;
            Optional<String> tableName = this.extractAliasOrTableName(singleRel.getInput());
            newHints = this.validateAndGetNewHints(tableName, oldHints);
        } else {
            throw new TableException(String.format("Unsupported node when resolving query hints: %s", node.getClass().getCanonicalName()));
        }
        RelNode newNode = super.visitChildren(node);
        List<RelHint> mergedHints = this.mergeQueryHintsIfNecessary(newHints);
        return ((Hintable)((Object)newNode)).withHints(mergedHints);
    }

    private List<RelHint> validateAndGetNewHints(Optional<String> leftName, Optional<String> rightName, List<RelHint> oldHints) {
        HashSet<RelHint> existentKVHints = new HashSet<RelHint>();
        ArrayList<RelHint> newHints = new ArrayList<RelHint>();
        for (RelHint hint : oldHints) {
            if (JoinStrategy.isLookupHint(hint.hintName)) {
                this.allHints.add(this.trimInheritPath(hint));
                Configuration conf = Configuration.fromMap(hint.kvOptions);
                String lookupTable = (String)conf.get(LookupJoinHintOptions.LOOKUP_TABLE);
                this.initOptionInfoAboutQueryHintsForCheck(hint.hintName, Collections.singletonList(lookupTable));
                assert (null != lookupTable);
                if (!rightName.isPresent() || !this.matchIdentifier(lookupTable, rightName.get())) continue;
                this.validHints.add(this.trimInheritPath(hint));
                this.updateInfoForOptionCheck(hint.hintName, rightName);
                newHints.add(hint);
                continue;
            }
            if (JoinStrategy.isJoinStrategy(hint.hintName)) {
                this.allHints.add(this.trimInheritPath(hint));
                this.initOptionInfoAboutQueryHintsForCheck(hint.hintName, hint.listOptions);
                List<String> newOptions = this.getNewJoinHintOptions(leftName, rightName, hint.listOptions, hint.hintName);
                boolean isValidOption = JoinStrategy.validOptions(hint.hintName, newOptions);
                if (!isValidOption) continue;
                this.validHints.add(this.trimInheritPath(hint));
                newHints.add(RelHint.builder(hint.hintName).hintOptions(Collections.singletonList(newOptions.get(0))).build());
                continue;
            }
            if (StateTtlHint.isStateTtlHint(hint.hintName)) {
                ArrayList<String> definedTables = new ArrayList<String>(hint.kvOptions.keySet());
                this.initOptionInfoAboutQueryHintsForCheck(hint.hintName, definedTables);
                Map<String, String> newKvOptions = this.getNewStateTtlHintOptions(leftName, rightName, hint.kvOptions, hint.hintName);
                if (newKvOptions.isEmpty()) continue;
                this.validHints.add(this.trimInheritPath(hint));
                newHints.add(RelHint.builder(hint.hintName).hintOptions(newKvOptions).build());
                continue;
            }
            if (existentKVHints.contains(hint)) continue;
            existentKVHints.add(hint);
            newHints.add(hint);
        }
        return newHints;
    }

    private List<RelHint> validateAndGetNewHints(Optional<String> inputName, List<RelHint> oldHints) {
        HashSet<RelHint> existentKVHints = new HashSet<RelHint>();
        ArrayList<RelHint> newHints = new ArrayList<RelHint>();
        for (RelHint hint : oldHints) {
            if (StateTtlHint.isStateTtlHint(hint.hintName)) {
                ArrayList<String> definedTables = new ArrayList<String>(hint.kvOptions.keySet());
                this.initOptionInfoAboutQueryHintsForCheck(hint.hintName, definedTables);
                List<String> newListOptions = this.getNewStateTtlHintOptions(inputName, hint.kvOptions, hint.hintName);
                if (newListOptions.isEmpty()) continue;
                this.validHints.add(this.trimInheritPath(hint));
                newHints.add(RelHint.builder(hint.hintName).hintOptions(newListOptions).build());
                continue;
            }
            if (existentKVHints.contains(hint)) continue;
            existentKVHints.add(hint);
            newHints.add(hint);
        }
        return newHints;
    }

    private List<String> getNewJoinHintOptions(Optional<String> leftName, Optional<String> rightName, List<String> listOptions, String hintName) {
        this.updateInfoForOptionCheck(hintName, leftName);
        this.updateInfoForOptionCheck(hintName, rightName);
        return listOptions.stream().map(option -> {
            if (leftName.isPresent() && rightName.isPresent() && this.matchIdentifier((String)option, (String)leftName.get()) && this.matchIdentifier((String)option, (String)rightName.get())) {
                throw new ValidationException(String.format("Ambitious option: %s in join hint: %s, the input relations are: %s, %s", option, hintName, leftName, rightName));
            }
            if (leftName.isPresent() && this.matchIdentifier((String)option, (String)leftName.get())) {
                return "LEFT";
            }
            if (rightName.isPresent() && this.matchIdentifier((String)option, (String)rightName.get())) {
                return "RIGHT";
            }
            return "";
        }).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    private Map<String, String> getNewStateTtlHintOptions(Optional<String> leftName, Optional<String> rightName, Map<String, String> kvOptions, String hintName) {
        this.updateInfoForOptionCheck(hintName, leftName);
        this.updateInfoForOptionCheck(hintName, rightName);
        HashMap<String, String> newOptions = new HashMap<String, String>();
        kvOptions.forEach((input, ttl) -> {
            if (leftName.isPresent() && rightName.isPresent() && this.matchIdentifier((String)input, (String)leftName.get()) && this.matchIdentifier((String)input, (String)rightName.get())) {
                throw new ValidationException(String.format("Ambitious option: %s in state ttl hint: %s, the input relations are: %s, %s", input, hintName, leftName, rightName));
            }
            if (leftName.isPresent() && this.matchIdentifier((String)input, (String)leftName.get())) {
                newOptions.put("LEFT", (String)ttl);
            } else if (rightName.isPresent() && this.matchIdentifier((String)input, (String)rightName.get())) {
                newOptions.put("RIGHT", (String)ttl);
            }
        });
        return newOptions;
    }

    private List<String> getNewStateTtlHintOptions(Optional<String> inputName, Map<String, String> kvOptions, String hintName) {
        this.updateInfoForOptionCheck(hintName, inputName);
        return kvOptions.entrySet().stream().filter(entry -> inputName.isPresent() && this.matchIdentifier((String)entry.getKey(), (String)inputName.get())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void validateHints() {
        HashSet<RelHint> invalidHints = new HashSet<RelHint>(this.allHints);
        invalidHints.removeAll(this.validHints);
        String errorPattern = "The options of following hints cannot match the name of input tables or views: %s";
        StringBuilder errorMsgSb = new StringBuilder();
        AtomicBoolean containsInvalidOptions = new AtomicBoolean(false);
        for (String hintName : this.allOptionsInQueryHints.keySet()) {
            Map<String, Boolean> optionCheckedStatus = this.allOptionsInQueryHints.get(hintName);
            errorMsgSb.append("\n");
            errorMsgSb.append(String.format("`%s` in `%s`", optionCheckedStatus.keySet().stream().filter(op -> {
                boolean checked;
                boolean bl = checked = (Boolean)optionCheckedStatus.get(op) == false;
                if (checked) {
                    containsInvalidOptions.set(true);
                }
                return checked;
            }).collect(Collectors.joining(", ")), hintName));
        }
        if (containsInvalidOptions.get()) {
            throw new ValidationException(String.format(errorPattern, errorMsgSb));
        }
        if (!invalidHints.isEmpty()) {
            errorPattern = "The options of following hints is invalid: %s";
            String errorMsg = invalidHints.stream().map(hint -> {
                String hintName = hint.hintName;
                if (JoinStrategy.isLookupHint(hintName) || StateTtlHint.isStateTtlHint(hintName)) {
                    return hint.hintName;
                }
                return hint.hintName + " :" + StringUtils.join(hint.listOptions, (String)", ");
            }).collect(Collectors.joining("\n", "\n", ""));
            throw new ValidationException(String.format(errorPattern, errorMsg));
        }
    }

    private RelHint trimInheritPath(RelHint hint) {
        RelHint.Builder builder = RelHint.builder(hint.hintName);
        if (hint.listOptions.isEmpty()) {
            return builder.hintOptions(hint.kvOptions).build();
        }
        return builder.hintOptions(hint.listOptions).build();
    }

    private Optional<String> extractAliasOrTableName(RelNode node) {
        Optional<String> tableName;
        Optional<String> aliasName = FlinkHints.getTableAlias(node);
        if (aliasName.isPresent()) {
            return aliasName;
        }
        Optional<TableScan> tableScan = this.getTableScan(node);
        if (tableScan.isPresent() && (tableName = FlinkHints.getTableName(tableScan.get().getTable())).isPresent()) {
            return tableName;
        }
        return Optional.empty();
    }

    private Optional<TableScan> getTableScan(RelNode node) {
        if (node instanceof TableScan) {
            return Optional.of((TableScan)node);
        }
        if (FlinkHints.canTransposeToTableScan(node)) {
            return this.getTableScan(node.getInput(0));
        }
        return Optional.empty();
    }

    private boolean matchIdentifier(String option, String tableIdentifier) {
        String[] optionNames = option.split("\\.");
        int optionNameLength = optionNames.length;
        String[] tableNames = tableIdentifier.split("\\.");
        int tableNameLength = tableNames.length;
        for (int i = 0; i < Math.min(optionNameLength, tableNameLength); ++i) {
            String currOptionName = optionNames[optionNameLength - 1 - i];
            String currTableName = tableNames[tableNameLength - 1 - i];
            if (currOptionName.equals(currTableName)) continue;
            return false;
        }
        return true;
    }

    private void initOptionInfoAboutQueryHintsForCheck(String hintName, List<String> definedTables) {
        if (this.allOptionsInQueryHints.containsKey(hintName)) {
            Map<String, Boolean> optionCheckedStatus = this.allOptionsInQueryHints.get(hintName);
            definedTables.forEach(table -> {
                if (!optionCheckedStatus.containsKey(table)) {
                    optionCheckedStatus.put((String)table, false);
                }
            });
        } else {
            this.allOptionsInQueryHints.put(hintName, new HashSet<String>(definedTables).stream().collect(Collectors.toMap(table -> table, table -> false)));
        }
    }

    private void updateInfoForOptionCheck(String hintName, Optional<String> tableName) {
        if (tableName.isPresent()) {
            Map<String, Boolean> optionMapper = this.allOptionsInQueryHints.get(hintName);
            for (String option : optionMapper.keySet()) {
                if (!this.matchIdentifier(option, tableName.get())) continue;
                this.allOptionsInQueryHints.get(hintName).put(option, true);
            }
        }
    }

    private List<RelHint> mergeQueryHintsIfNecessary(List<RelHint> hints) {
        ArrayList<RelHint> result = new ArrayList<RelHint>();
        HashMap<String, HashMap<String, String>> kvHintsMap = new HashMap<String, HashMap<String, String>>();
        HashMap<String, String> listHintsMap = new HashMap<String, String>();
        for (RelHint hint : hints) {
            String hintName = hint.hintName;
            if (JoinStrategy.isJoinStrategy(hintName) || FlinkHints.isAliasHint(hintName)) {
                result.add(hint);
                continue;
            }
            if (!hint.kvOptions.isEmpty()) {
                HashMap<String, String> kvOptions = new HashMap<String, String>(hint.kvOptions);
                if (kvHintsMap.containsKey(hintName)) {
                    Map existingOptions = (Map)kvHintsMap.get(hintName);
                    for (String key : kvOptions.keySet()) {
                        existingOptions.computeIfAbsent(key, k -> (String)kvOptions.get(key));
                    }
                    continue;
                }
                kvHintsMap.put(hintName, kvOptions);
                continue;
            }
            if (!hint.listOptions.isEmpty()) {
                listHintsMap.computeIfAbsent(hintName, k -> hint.listOptions.get(0));
                continue;
            }
            throw new ValidationException(String.format("Invalid %s hint, the key-value options and list options are all empty", hintName));
        }
        for (String kvHintName : kvHintsMap.keySet()) {
            result.add(RelHint.builder(kvHintName).hintOptions((Map)kvHintsMap.get(kvHintName)).build());
        }
        for (String listHintName : listHintsMap.keySet()) {
            result.add(RelHint.builder(listHintName).hintOptions(Collections.singletonList(listHintsMap.get(listHintName))).build());
        }
        return result;
    }
}

